% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{summary.BayesMallowsSMC2}
\alias{summary.BayesMallowsSMC2}
\title{Summary Method for BayesMallowsSMC2 Objects}
\usage{
\method{summary}{BayesMallowsSMC2}(object, ...)
}
\arguments{
\item{object}{An object of class \code{BayesMallowsSMC2}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An object of class \code{summary.BayesMallowsSMC2}, which is a list
containing summary information about the model.
}
\description{
Creates a summary of a BayesMallowsSMC2 object returned by
\code{\link[=compute_sequentially]{compute_sequentially()}}.
}
\details{
The summary method creates a summary object that includes:
\itemize{
\item Number of particles
\item Number of timepoints
\item Number of items
\item Number of clusters
\item Log marginal likelihood
\item Final effective sample size (ESS)
\item Number of resampling events
\item Posterior mean of alpha for each cluster
\item Posterior standard deviation of alpha for each cluster
}
}
\examples{
# Fit a model with complete rankings
set.seed(123)
mod <- compute_sequentially(
  complete_rankings,
  hyperparameters = set_hyperparameters(n_items = 5),
  smc_options = set_smc_options(n_particles = 100, n_particle_filters = 1)
)

# Create summary
summary(mod)

}
