% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InVars.R
\name{InVars}
\alias{InVars}
\alias{AddInVars}
\alias{RemoveInVars}
\title{Add or remove a input variables in a problem}
\usage{
AddInVars(
  ThisProblem,
  InVarName,
  InVarMCName = NULL,
  InVarType = c("Temperature", "pH", "WHAM-FA", "WHAM-HA", "WHAM-HAFA", "PercHA",
    "PercAFA", "Misc"),
  InVarMCR = match(InVarMCName, ThisProblem$Mass$Name, nomatch = -1L),
  DoCheck = TRUE
)

RemoveInVars(ThisProblem, InVarToRemove, DoCheck = TRUE)
}
\arguments{
\item{ThisProblem}{A list object with a structure like that returned by
`BlankProblem()`.}

\item{InVarName}{A character vector with the name(s) of the input input
variable(s).}

\item{InVarMCName}{A character vector with the name(s) of the mass
compartments the new input variables are associated with. Does not need to
be specified if `InVarMCR` is specified instead.}

\item{InVarType}{A character vector with the types of the new input
variables. Must be one of "Temp", "pH", "WHAM-HA", "WHAM-FA", "WHAM-HAFA",
"PercHA", "PercAFA", and "Misc".}

\item{InVarMCR}{(optional) A character vector with the indices of the mass
compartments the new input variables are associated with. Only needs to be
specified if `InVarMCName` is not specified.}

\item{DoCheck}{A logical value indicating whether checks should be performed
on the incoming and outgoing problem objects. Defaults to `TRUE`, as you
usually want to make sure something isn't awry, but the value is often set
to `FALSE` when used internally (like in DefineProblem) so the problem is
only checked once at the end.}

\item{InVarToRemove}{A character vector with names or indices of the input
variable(s) to remove from `ThisProblem`.}
}
\value{
`ThisProblem`, with the changed input variables. If the input
  variable being added is pH, "H" and "OH" components will also be added as
  fixed activity components.
}
\description{
Add or remove a input variables in a problem
}
\examples{
print(carbonate_system_problem$InVar)
my_new_problem = carbonate_system_problem
my_new_problem = AddInVars(ThisProblem = my_new_problem,
                           InVarName = c("Humics", "Fulvics"),
                           InVarMCName = "Water",
                           InVarType = c("WHAM-HA","WHAM-FA"))
my_new_problem = RemoveInVars(ThisProblem = my_new_problem,
                              InVarToRemove = "Humics")
print(my_new_problem$InVar)

}
\seealso{
Other problem manipulation functions: 
\code{\link{BlankProblem}()},
\code{\link{Components}},
\code{\link{CriticalValues}},
\code{\link{InLabs}},
\code{\link{MassCompartments}},
\code{\link{Phases}},
\code{\link{SpecialDefs}},
\code{\link{Species}}
}
\concept{problem manipulation functions}
