% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvertWHAMVThermoFile.R
\name{ConvertWHAMVThermoFile}
\alias{ConvertWHAMVThermoFile}
\title{Convert from a WHAM V thermodynamic database file}
\usage{
ConvertWHAMVThermoFile(ThermoDBSName, RWHAMFile = NULL, RParamFile = NULL)
}
\arguments{
\item{ThermoDBSName}{Character string with the file path of the WHAM
thermodynamic database file to convert (typically ".dbs" file extension).}

\item{RWHAMFile}{(optional) Character string with the file path of the
R-format WHAM parameter file to save (suggest file extension ".wdat").}

\item{RParamFile}{(optional) Character string with the file path of the
R-format BLM parameter file to save (suggest file extension ".dat4").}
}
\value{
The BLMEngineInR-compatible chemistry problem object. If RWHAMFile or
  RParamFile are provided, this will return invisibly.
}
\description{
This function will take a thermodynamic database file used by
  the Windemere Humic Aqueous Model (WHAM) V and the Windows BLM and convert
  it into a BLMEngineInR chemistry problem list.
}
