% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{Kernel}
\alias{Kernel}
\title{Base R6 class for Kernels}
\description{
Abstract base class for kernels (Should not be instantiated)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{kernel_variance}}{The variance of the kernel}

\item{\code{jitter_value}}{The jitter value to add to the kernel matrix}

\item{\code{distance_matrix}}{The distance matrix between points in a tensor format}

\item{\code{name}}{The kernel's name}

\item{\code{parameters}}{The parameters of the kernel (list of \code{KernelParameter})}

\item{\code{covariance_matrix}}{The covariance matrix of the kernel in a tensor format}

\item{\code{positions_df}}{The positions of the points in a dataframe format}

\item{\code{has_dist_matrix}}{Identify if the kernel has a distance matrix or not}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Kernel-new}{\code{Kernel$new()}}
\item \href{#method-Kernel-core_kernel_fn}{\code{Kernel$core_kernel_fn()}}
\item \href{#method-Kernel-add_jitter_to_kernel}{\code{Kernel$add_jitter_to_kernel()}}
\item \href{#method-Kernel-kernel_gen}{\code{Kernel$kernel_gen()}}
\item \href{#method-Kernel-set_positions}{\code{Kernel$set_positions()}}
\item \href{#method-Kernel-plot}{\code{Kernel$plot()}}
\item \href{#method-Kernel-clone}{\code{Kernel$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kernel-new"></a>}}
\if{latex}{\out{\hypertarget{method-Kernel-new}{}}}
\subsection{Method \code{new()}}{
Kernel abstract base constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kernel$new(kernel_variance, jitter_value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{kernel_variance}}{Numeric: The variance of the kernel}

\item{\code{jitter_value}}{Numeric: The jitter value to add to the kernel matrix}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Kernel} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kernel-core_kernel_fn"></a>}}
\if{latex}{\out{\hypertarget{method-Kernel-core_kernel_fn}{}}}
\subsection{Method \code{core_kernel_fn()}}{
Abstract method to compute the core kernel's covariance matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kernel$core_kernel_fn()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kernel-add_jitter_to_kernel"></a>}}
\if{latex}{\out{\hypertarget{method-Kernel-add_jitter_to_kernel}{}}}
\subsection{Method \code{add_jitter_to_kernel()}}{
Method to add jitter to the kernel's covariance matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kernel$add_jitter_to_kernel()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kernel-kernel_gen"></a>}}
\if{latex}{\out{\hypertarget{method-Kernel-kernel_gen}{}}}
\subsection{Method \code{kernel_gen()}}{
Method to compute the kernel's covariance matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kernel$kernel_gen()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kernel-set_positions"></a>}}
\if{latex}{\out{\hypertarget{method-Kernel-set_positions}{}}}
\subsection{Method \code{set_positions()}}{
Method to set the kernel's positions and compute the distance matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kernel$set_positions(positions_df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{positions_df}}{Dataframe: The positions of the points in a dataframe format}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kernel-plot"></a>}}
\if{latex}{\out{\hypertarget{method-Kernel-plot}{}}}
\subsection{Method \code{plot()}}{
Method to plot the kernel's covariance matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kernel$plot(show_figure = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{show_figure}}{Boolean: If TRUE, the figure is shown, otherwise it is returned}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{show_figure} is TRUE, the figure is shown, otherwise it is returned
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kernel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Kernel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kernel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
