% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPSclass.R
\name{PPS}
\alias{PPS}
\title{Create a PPS object}
\usage{
PPS(num_hai_patients = NULL, num_survey_patients = NULL,
  length_of_stay = NULL, loi_pps = NULL, hospital_discharges = NULL,
  num_hai_patients_by_stratum = NULL,
  num_hai_patients_by_stratum_prior = NULL, mccabe_scores_distr = NULL,
  mccabe_by_stratum_prior = NULL, mccabe_life_exp = NULL,
  num_survey_patients_by_stratum = NULL, population = NULL,
  country = "")
}
\arguments{
\item{num_hai_patients}{Named numeric containing patients having healthcare-associated infections.}

\item{num_survey_patients}{Number of patients in point prevalence survey.}

\item{length_of_stay}{Length of stay of all patients in hospitals. This is need for the prevalence to incidence conversion with the Rhame-Sudderth formula.}

\item{loi_pps}{A list containing length of infections from all patients in the PPS. The length of infection of all healthcare-associated infections. In PPS this is usually approximated as the time from infection onset until the date of the survey.}

\item{hospital_discharges}{The number of hospital discharges.}

\item{num_hai_patients_by_stratum}{A list containing for each infection the number of patients in each age and gender stratum.}

\item{num_hai_patients_by_stratum_prior}{The prior weight (counts) for each infection, age and gender stratum. This is used for smooting the age and gender distribution when small numbers are observed.}

\item{mccabe_scores_distr}{The observed McCabe scores (counts) for each infection, age and gender stratum from the PPS.}

\item{mccabe_by_stratum_prior}{The prior weight (counts) for each infection, McCabe score, age and gender stratum. This is used for smooting the age and gender distribution when small numbers are observed.}

\item{mccabe_life_exp}{Named list containing remaining life expectancies for each McCabe score (NONFATAL, ULTFATAL, RAPFATAL).}

\item{num_survey_patients_by_stratum}{Number of survey patients stratified by infection, age and gender. If this parameter is provided the methodology described in Cassini et al. (2016) <doi:https://doi.org/10.1371/journal.pmed.1002150> is applied.}

\item{population}{Population size.}

\item{country}{Name of the country.}
}
\value{
A PPS class object.
}
\description{
This function creates a PPS object.
}
\examples{

data(german_pps_2011_repr)
german_pps_repr = PPS(num_hai_patients = num_hai_patients,
    num_hai_patients_by_stratum = num_hai_patients_by_stratum,
    num_hai_patients_by_stratum_prior = num_hai_patients_by_stratum_prior,
    num_survey_patients = num_survey_patients,
    length_of_stay = length_of_stay,
    loi_pps = loi_pps,
    mccabe_scores_distr = mccabe_scores_distr,
    mccabe_life_exp = mccabe_life_exp,
    hospital_discharges = hospital_discharges,
    population = population,
    country="Germany (representative sample)")
german_pps_repr

}
\seealso{
\code{\linkS4class{PPS}}
}
