% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{hyper.arrangement}
\alias{hyper.arrangement}
\title{Functional arrangement within a functional space (generic function).}
\usage{
hyper.arrangement(
  comm,
  space,
  pool = NULL,
  stat = "PNCP",
  distances = seq(0, 1, 0.01),
  type = "SES",
  alpha = 0.05,
  runs = 99,
  plot = TRUE
)
}
\arguments{
\item{comm}{Coordinates of species within the functional space.}

\item{space}{Coordinates of stochastic points representing the functional space.
These will be used to perform a random displacement null model.}

\item{pool}{Species pool coordinates. When specified (typically coordinates from
\code{hyper.build} output), the function performs a random selection null model,
drawing species randomly from the provided pool coordinates. When \code{NULL} (default),
the function performs a random displacement null model using the stochastic points from space argument.
Must be a matrix or data.frame of coordinates matching the functional space dimensions.}

\item{stat}{statistic to be calculated. One of c("PNCP", "NNCP"), meaning
"cumulative proportion of pairwise neighbors" and "cumulative proportion of nearest neighbors", respectively.}

\item{distances}{vector of distances to be considered in calculations}

\item{type}{Envelope type for testing significance. One of c("ecdf", "norm", "SES"), meaning
"empirical cumulative distribution", "normalized envelope" (between 0-1, 0.5 indicate randomness,
more than 0.5 - clustered; less than 0.5 - inhibition), and "standardized effect size", respectively.}

\item{alpha}{alpha value to consider in significance testing (p-value) when type = "SES"}

\item{runs}{number of simulations for significance testing}

\item{plot}{whether to plot the results}
}
\value{
A list with observed PNCP or NNCP values, a matrix of simulated values at r distances (r x sim), and standard effect size (if type = "SES").
}
\description{
Functional arrangement of a community, measuring the distribution of
species within the total functional space at multiple spatial scales. This is a
generic function to be used with any functional volume building method, as long as
the functional space can be represented by stochastic points.
}
\details{
This function measures the functional arrangement (Carvalho & Cardoso, 2025)
of a n-dimensional functional space, namely the distribution of species within the total
trait at multiple spatial scales. Species coordinates are typically obtained through ordination methods.
The functional space can be constructed using one-class support vector machines (e.g., as implemented
in the hyper.build function or as implemented in other packages, such as kernlab or e1071) or alternative approaches,
as long as they can represent the functional space through stochastic points.
}
\examples{
\dontrun{
comm = c(100,3,0,5,3)
names(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")

trait = data.frame(body = c(1,2,3,4,2), beak = c(1,5,4,1,2))
rownames(trait) = names(comm)

hv = kernel.build(comm, trait, method.hv = "svm", svm.nu = 0.01, svm.gamma = 0.25)
hyper.arrangement(comm = hv@Data, space = hv@RandomPoints)
}
}
\references{
Carvalho, J.C. & Cardoso, P. (2025) Quantifying species distribution within the functional space.
}
