% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sproc.R
\name{get_stored_procedure}
\alias{get_stored_procedure}
\alias{cosmos_stored_procedure}
\alias{get_stored_procedure.cosmos_container}
\alias{list_stored_procedures}
\alias{create_stored_procedure}
\alias{create_stored_procedure.cosmos_container}
\alias{exec_stored_procedure}
\alias{exec_stored_procedure.cosmos_container}
\alias{exec_stored_procedure.cosmos_stored_procedure}
\alias{replace_stored_procedure}
\alias{replace_stored_procedure.cosmos_container}
\alias{replace_stored_procedure.cosmos_stored_procedure}
\alias{delete_stored_procedure}
\alias{delete_stored_procedure.cosmos_container}
\alias{delete_stored_procedure.cosmos_stored_procedure}
\title{Methods for working with Azure Cosmos DB stored procedures}
\usage{
get_stored_procedure(object, ...)

\method{get_stored_procedure}{cosmos_container}(object, procname, ...)

list_stored_procedures(object, ...)

create_stored_procedure(object, ...)

\method{create_stored_procedure}{cosmos_container}(object, procname, body, ...)

exec_stored_procedure(object, ...)

\method{exec_stored_procedure}{cosmos_container}(object, procname, parameters = list(), ...)

\method{exec_stored_procedure}{cosmos_stored_procedure}(object, ...)

replace_stored_procedure(object, ...)

\method{replace_stored_procedure}{cosmos_container}(object, procname, body, ...)

\method{replace_stored_procedure}{cosmos_stored_procedure}(object, body, ...)

delete_stored_procedure(object, ...)

\method{delete_stored_procedure}{cosmos_container}(object, procname, confirm = TRUE, ...)

\method{delete_stored_procedure}{cosmos_stored_procedure}(object, ...)
}
\arguments{
\item{object}{A Cosmos DB container object, as obtained by \code{get_cosmos_container} or \code{create_cosmos_container}, or for \code{delete_stored_procedure.cosmos_stored_procedure}, the stored procedure object.}

\item{...}{Optional arguments passed to lower-level functions.}

\item{procname}{The name of the stored procedure.}

\item{body}{For \code{create_stored_procedure} and \code{replace_stored_procedure}, the body of the stored procedure. This can be either a character string containing the source code, or the name of a source file.}

\item{parameters}{For \code{exec_stored_procedure}, a list of parameters to pass to the procedure.}

\item{confirm}{For \code{delete_stored_procedure}, whether to ask for confirmation before deleting.}
}
\value{
For \code{get_stored_procedure} and \code{create_stored_procedure}, an object of class \code{cosmos_stored_procedure}. For \code{list_stored_procedures}, a list of such objects.
}
\description{
Methods for working with Azure Cosmos DB stored procedures
}
\details{
These are methods for working with stored procedures in Azure Cosmos DB using the core (SQL) API. In the Cosmos DB model, stored procedures are written in JavaScript and associated with a container.
}
\examples{
\dontrun{

endp <- cosmos_endpoint("https://myaccount.documents.azure.com:443/", key="mykey")
db <- get_cosmos_database(endp, "mydatabase")
cont <- create_cosmos_container(db, "mycontainer", partition_key="sex")

# a simple stored procedure
src <- 'function helloworld() {
   var context = getContext();
    var response = context.getResponse();
    response.setBody("Hello, World");
}'
create_stored_procedure(cont, "helloworld", src)
sproc <- get_stored_procedure(cont, "helloworld")
exec_stored_procedure(sproc)

# more complex example: uploading data
sproc2 <- create_stored_procedure(cont, "myBulkUpload",
    body=system.file("srcjs/bulkUpload.js", package="AzureCosmosR"))

list_stored_procedures(cont)

sw_male <- dplyr::filter(dplyr::starwars, sex == "male")
exec_stored_procedure(sproc2, parameters=list(sw_male))

delete_stored_procedure(sproc)
delete_stored_procedure(sproc2)

}
}
\seealso{
\link{cosmos_container}, \link{get_udf}
}
