% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.PACF}
\alias{Plot.PACF}
\title{Plot.PACF}
\usage{
Plot.PACF(
  dt = NULL,
  YVar = NULL,
  DateVar = NULL,
  TimeUnit = NULL,
  MaxLags = 50,
  YVarTrans = "Identity",
  AggMethod = "sum",
  Height = NULL,
  Width = NULL,
  Title = "Partial Autocorrelation Plot",
  EchartsTheme = "macarons",
  TextColor = "white",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = "#63aeff",
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  xaxis.fontSize = 14,
  yaxis.fontSize = 14,
  xaxis.rotate = 0,
  yaxis.rotate = 0,
  ContainLabel = TRUE,
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{YVar}{Y-Axis variable name}

\item{DateVar}{Date column in data}

\item{TimeUnit}{Select from "hour", "day", "week", "month", "quarter", "year"}

\item{MaxLags}{Max value for lags to test}

\item{YVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{AggMethod}{Choose from 'mean', 'sum', 'sd', and 'median'}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{title}

\item{EchartsTheme}{"auritus","azul","bee-inspired","blue","caravan","carp","chalk","cool","dark-bold","dark","eduardo", #' "essos","forest","fresh-cut","fruit","gray","green","halloween","helianthus","infographic","inspired", #' "jazz","london","dark","macarons","macarons2","mint","purple-passion","red-velvet","red","roma","royal", #' "sakura","shine","tech-blue","vintage","walden","wef","weforum","westeros","wonderland"}

\item{TextColor}{'darkblue'}

\item{title.fontSize}{22}

\item{title.fontWeight}{"bold"}

\item{title.textShadowColor}{'#63aeff'}

\item{title.textShadowBlur}{3}

\item{title.textShadowOffsetY}{1}

\item{title.textShadowOffsetX}{-1}

\item{xaxis.fontSize}{14}

\item{yaxis.fontSize}{14}

\item{xaxis.rotate}{0}

\item{yaxis.rotate}{0}

\item{ContainLabel}{TRUE}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
Build a partial autocorrelation plot by simply passing arguments to a single function
}
\seealso{
Other Standard Plots: 
\code{\link{ACF}()},
\code{\link{Area}()},
\code{\link{Bar}()},
\code{\link{BarPlot3D}()},
\code{\link{Box}()},
\code{\link{Copula}()},
\code{\link{Copula3D}()},
\code{\link{CorrMatrix}()},
\code{\link{Density}()},
\code{\link{Donut}()},
\code{\link{HeatMap}()},
\code{\link{Histogram}()},
\code{\link{Line}()},
\code{\link{PACF}()},
\code{\link{Parallel}()},
\code{\link{Pie}()},
\code{\link{Plot.ACF}()},
\code{\link{Plot.Area}()},
\code{\link{Plot.Bar}()},
\code{\link{Plot.BarPlot3D}()},
\code{\link{Plot.Box}()},
\code{\link{Plot.Copula}()},
\code{\link{Plot.Copula3D}()},
\code{\link{Plot.CorrMatrix}()},
\code{\link{Plot.Density}()},
\code{\link{Plot.Donut}()},
\code{\link{Plot.HeatMap}()},
\code{\link{Plot.Histogram}()},
\code{\link{Plot.Line}()},
\code{\link{Plot.Parallel}()},
\code{\link{Plot.Pie}()},
\code{\link{Plot.ProbabilityPlot}()},
\code{\link{Plot.Radar}()},
\code{\link{Plot.River}()},
\code{\link{Plot.Rosetype}()},
\code{\link{Plot.Scatter}()},
\code{\link{Plot.Scatter3D}()},
\code{\link{Plot.StackedBar}()},
\code{\link{Plot.Step}()},
\code{\link{Plot.WordCloud}()},
\code{\link{ProbabilityPlot}()},
\code{\link{Radar}()},
\code{\link{River}()},
\code{\link{Rosetype}()},
\code{\link{Scatter}()},
\code{\link{Scatter3D}()},
\code{\link{StackedBar}()},
\code{\link{Step}()},
\code{\link{WordCloud}()}
}
\author{
Adrian Antico
}
\concept{Standard Plots}
