#![cfg_attr(not(any(feature = "std", test)), no_std)]
#![allow(unexpected_cfgs)] // why does this even exist?

#[cfg(test)]
extern crate core;

pub use self::{arch::*, data::*, error::*, flag::*, io::*, number::*};

#[cfg(target_arch = "aarch64")]
#[path = "arch/aarch64.rs"]
mod arch;

#[cfg(target_arch = "riscv64")]
#[path = "arch/riscv64.rs"]
mod arch;

#[cfg(target_arch = "x86")]
#[path = "arch/x86.rs"]
mod arch;

#[cfg(target_arch = "x86_64")]
#[path = "arch/x86_64.rs"]
mod arch;


#[cfg(feature = "userspace")]
pub mod call;

#[cfg(feature = "userspace")]
pub use call::*;


pub mod data;

pub mod dirent;


pub mod error;


pub mod flag;


pub mod io;


pub mod number;


pub mod sigabi;


pub mod schemev2;

pub mod scheme;
pub use scheme::*;
