
use std::iter::{FusedIterator, IntoIterator};
use alloc::rc::Rc;
use std::cell::RefCell;


#[derive(Debug)]
pub struct RcIter<I> {

    pub rciter: Rc<RefCell<I>>,
}



































pub fn rciter<I>(iterable: I) -> RcIter<I::IntoIter>
    where I: IntoIterator
{
    RcIter { rciter: Rc::new(RefCell::new(iterable.into_iter())) }
}

impl<I> Clone for RcIter<I> {
    clone_fields!(rciter);
}

impl<A, I> Iterator for RcIter<I>
    where I: Iterator<Item = A>
{
    type Item = A;
    #[inline]
    fn next(&mut self) -> Option<Self::Item> {
        self.rciter.borrow_mut().next()
    }

    #[inline]
    fn size_hint(&self) -> (usize, Option<usize>) {



        (0, self.rciter.borrow().size_hint().1)
    }
}

impl<I> DoubleEndedIterator for RcIter<I>
    where I: DoubleEndedIterator
{
    #[inline]
    fn next_back(&mut self) -> Option<Self::Item> {
        self.rciter.borrow_mut().next_back()
    }
}


impl<'a, I> IntoIterator for &'a RcIter<I>
    where I: Iterator
{
    type Item = I::Item;
    type IntoIter = RcIter<I>;

    fn into_iter(self) -> RcIter<I> {
        self.clone()
    }
}


impl<A, I> FusedIterator for RcIter<I>
    where I: FusedIterator<Item = A>
{}
