% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt.R
\name{melt}
\alias{melt}
\alias{melt.zoocat}
\title{Melt a \code{zoocat} Object}
\usage{
\method{melt}{zoocat}(data, value.name = "value",
  index.name = indname(data), na.rm = FALSE, ...)
}
\arguments{
\item{data}{object to melt.}

\item{value.name}{name of the column used to store values. It is valid only when 
a data frame is returned.}

\item{index.name}{name of the column used to store the index of the \code{zoocat} object.}

\item{na.rm}{as \code{melt} in reshape2. Should NA values be removed from the data set?}

\item{...}{further arguments.}
}
\value{
a data frame.
}
\description{
Melt a \code{zoocat} to a data frame of the long table style,
which is similar as in package \code{reshape2}.
}
\examples{

x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = c('x', 'y', 'z', 'a'))
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr)
melt(zc)

zm <- as.zoomly(zc)
melt(zm)

}

