% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zooaRch.r
\name{fuse.func}
\alias{fuse.func}
\title{Epiphyseal fusion survival analysis}
\usage{
fuse.func(data, iter = 1000, ci = 95, plotci = TRUE, plot.title = NULL)
}
\arguments{
\item{data}{This function inputs a dataframe composed of three columns, names must be 
'Identification', 'Element', 'Fusion'. The first column denotes the arbitrary ID # and can be left blank if desired;
the second is the element name (differentiate proximal and distal as needed);
the third is the state of fusion. It must be 'Fused', 'Fusing', or 'Unfused' 
(NOTE: elements coded as 'Fusing' will be counted as 'Fused').}

\item{iter}{A numeric value indicating the number of bootstrap iterations. Defaults to 100.}

\item{ci}{Numerical value indicating desired CI level (e.g., 90, 95, 99). Defaults to 95.}

\item{plotci}{A logical value indicating wether user wishes an output plot. Default = TRUE.}

\item{plot.title}{A character value providing a title for the plot. Default is NULL.}
}
\value{
Function returns a matrix with the following components 
  \item{Lower and Upper CI}{typically the 97.5 and 2.5 percentile markers}
  \item{Point Value}{the y value on the percent Fused survivorship curve}
}
\description{
A general function to perform survival analysis of zooarchaeological epiphyseal fusion data.
}
\details{
The function constructs Confidence Intervals based off bootstraps of percent Fused values
}
\examples{
# Example 1
# fusedat<-data(marjRab.fuse)
# test<-fuse.func(fusedat, iter=100, plotci=TRUE, plot.title="Fusion Example") 
# send the following into the console as you are prompted
# interactively
# 5
# 2
# 1
# 1
# 1
# 1
# Px.Humerus
# Ds.Humerus
# Calcaneus
# Ds.Tibia
# Px.Femur
# Phalanx1
}
\author{
Jesse Wolfhagen, Max Price, and Erik Otarola-Castillo.
}
\references{
Klein, R.G., Cruz-Uribe, K., 1983. The Analysis of Animal Bones from Archaeological Sites, University of Chicago Press, Chicago.

Lyman, R.L., 1994. Vertebrate Taphonomy, Cambridge University Press, Cambridge.

Zeder, M.A., 2006. Reconciling Rates of Long Bone Fusion and Tooth Eruption in Sheep (Ovis) and Goat (Capra), in: Ruscillo, D. (Ed.), Recent Advances in Ageing and Sexing Animal Bones, Oxbow Books, Oxford.

Twiss, K.C., 2008. An Assessment of the Archaeological Applicability of Faunal Ageing Methods Based on Dental Wear, International Journal of Osteoarchaeology 18, 329-351.

Price, M.D., Buckley, M., Rowan, Y.M., Kersel, M., 2013. Animal Management Strategies during the Chalcolithic in the Lower Galilee: New Data from Marj Rabba, Paleorient 39, 183-200.
}
\keyword{analysis}

