% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_load_labels.R
\name{zi_load_labels}
\alias{zi_load_labels}
\title{Load Label Data}
\usage{
zi_load_labels(source = "UDS", type = "zip5", include_scf = FALSE,
    vintage = 2022)
}
\arguments{
\item{source}{A required character scalar; specifies the source of the label
data. The only supported sources are \code{'UDS'} (default) and
\code{'USPS'}.}

\item{type}{A required character scalar; one of either  \code{'zip3'} or
\code{'zip5'}. The  \code{'zip3'} type is only available from the \code{'USPS'}
source, while the \code{'zip5'} type is available from \code{'UDS'}.}

\item{include_scf}{A logical scalar required when \code{source = 'USPS'} and
\code{type = 'zip3'}; specifying whether to include the SCF (Sectional
Center Facility) ID in the output. The default is \code{FALSE}.}

\item{vintage}{A required character or numeric scalar; specifying the date
for \code{source = 'USPS'} or the year of the data for \code{source = 'UDS'}.
The \code{zip_load_labels_list()} function can be used to see available
date values for \code{source = 'USPS'}.}
}
\value{
A tibble with the specified label data for either five or three-digit
    ZIP Codes.
}
\description{
This function loads a specific label data set that can be used to
    label five or three-digit ZIP codes in a data frame.
}
\details{
Labels are approximations of the actual location of a ZIP Code. For
    five-digit ZIP Codes, the city and state may or may not correspond to
    an individuals' mailing address city (since multiple cities may be
    accepted as valid by USPS for a particular ZIP Code) or state (since ZIP
    Codes may cross state lines).

    For three-digit ZIP Codes, the area and state may or may not correspond to
    an individuals' mailing address state (since SCFs cover multiple states).
    For example, the three digit ZIP Code \code{010} covers Western Massachusetts
    in practice, but is assigned to the state of Connecticut.
}
\examples{
\donttest{
  # zip5 labels via UDS
  zi_load_labels(source = "UDS", type = "zip5", vintage = 2022)

  # zip3 labels via USPS
  zi_load_labels(source = "USPS", type = "zip3", vintage = 202408)
}

}
