% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfPolylog.R
\name{zipfPolylog}
\alias{zipfPolylog}
\alias{dzipfpolylog}
\title{The Zipf-Polylog Distribution (Zipf-Polylog).}
\usage{
dzipfpolylog(x, alpha, beta, log = FALSE, nSum = 1000)
}
\arguments{
\item{x}{Vector of positive integer values.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 1} ).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta > 0} ).}

\item{log}{Logical; if TRUE, probabilities p are given as log(p).}

\item{nSum}{The number of terms used for computing the Polilogarithm function [Default = 1000].}
}
\value{
{
\code{dzipfpolylog} gives the probability mass function
}
}
\description{
Probability mass function of the Zipf-Polylog distribution with parameters \eqn{\alpha} and \eqn{\beta}.
The support of the Zipf-Polylog distribution are the strictly positive integer numbers large or equal
than one.
}
\details{
The \emph{probability mass function} at a positive integer value \eqn{x} of the Zipf-Polylog distribution with
parameters \eqn{\alpha} and \eqn{\beta} is computed as follows:
}
\examples{
dzipfpolylog(1:10, 1.61, 0.98)

}
