% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Plot.zeta.ddecays}
\alias{Plot.zeta.ddecays}
\title{Zeta distance-decay plotting for multiple orders}
\usage{
Plot.zeta.ddecays(zeta.ddecays)
}
\arguments{
\item{zeta.ddecays}{A list produced by the function \code{Zeta.ddecays}.}
}
\value{
A plot of the zeta distance-decay with the orders on the x-axis and the slope of the linear distance-decays on the y-axis.
}
\description{
Plots the output of the function \code{Zeta.ddecays}.
}
\examples{
utils::data(bird.spec.coarse)
xy.bird <- bird.spec.coarse[,1:2]
data.spec.bird <- bird.spec.coarse[,3:193]

dev.new()
zeta.ddecays.bird <- Zeta.ddecays(xy.bird, data.spec.bird, sam = 100, orders = 2:5,
    plot = FALSE, confint.level = 0.95)
Plot.zeta.ddecays(zeta.ddecays.bird)

##########

utils::data(Marion.species)
xy.marion <- Marion.species[,1:2]
data.spec.marion <- Marion.species[,3:33]

dev.new()
zeta.ddecays.marion <- Zeta.ddecays(xy.marion, data.spec.marion, sam = 100,
   orders = 2:5, plot = FALSE, confint.level = 0.95)
Plot.zeta.ddecays(zeta.ddecays.marion)

}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}}, \code{\link{Zeta.ddecays}},

\code{\link{Zeta.ddecay}}, \code{\link{Plot.zeta.ddecay}}
}
