% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Ispline}
\alias{Ispline}
\title{Transform data using I-splines}
\usage{
Ispline(dat, order.ispline = 2, kn.ispline = 1, rescale = 0)
}
\arguments{
\item{dat}{A data frame whose columns are variables to be transformed using I-splines.}

\item{order.ispline}{Order of the I-spline.}

\item{kn.ispline}{Number of knots in the I-spline.}

\item{rescale}{Indicates how to rescale the values between 0 and 1. Default is 0, which divides the data by the maximum value. Any other value corresponds to setting the minimum value to 0.}
}
\value{
\code{Ispline} returns a data frame with the same number of rows as dat and

\code{ncol(dat)} * \code{(order.ispline} + \code{kn.ispline)} columns.
}
\description{
Evaluates the I-splines for all variables of a data frame, as performed in \code{Zeta.msgdm}.
}
\examples{
utils::data(bird.env.coarse)
data.env <- bird.env.coarse[,3:9]
data.env.splines <- Ispline(data.env)
}
\references{
Ramsay, J. O. (1988). Monotone regression splines in action. \emph{Statistical Science}, 425-441.

Ferrier, S., Manion, G., Elith, J., & Richardson, K. (2007). Using generalized dissimilarity modelling to analyse and predict patterns of beta diversity in regional biodiversity assessment. \emph{Diversity and Distributions}, 13(3), 252-264.
}
\seealso{
\code{\link{Zeta.msgdm}}
}

