% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/functions_package.R
\name{Zeta.gam}
\alias{Zeta.gam}
\title{Generalized additive model of zeta for a set of environmental variables and distance}
\usage{
Zeta.gam(data.spec, data.env, xy = NULL, order = 1, sam = 1000,
  standard = TRUE, method = "mean")
}
\arguments{
\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{data.env}{Sites-by-variable data frame, with sites as rows and environmental variables as columns.}

\item{xy}{Site coordinates}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{sam}{Number of samples for which the zeta-diversity is computed.}

\item{standard}{Boolean parameter indicating if the spatial distances and differences in environmental variables should be standardized between 0 and 1.}

\item{method}{Indicates how to combine the pairwise differences and distances for more than 3 sites. Method can be "\code{mean}" or "\code{max}".}
}
\value{
\code{Zeta.gam} returns an object of class "\code{gam}", containing the output of the generalized additive model of zeta over the environmental variables.
}
\description{
Computes a generalized additive model of zeta diversity for a given order (number of assemblages or sites) against a set of environmental variables and distances between sites.
}
\details{
If \code{order = 1}, the environmental variables must be numeric and are used as such in the regression. If \code{order>1}, the environmental variables can be numeric or factorial.
}
\examples{
data(BCI.spec.coarse)
xy <- BCI.spec.coarse[1:2]
data.spec <- BCI.spec.coarse[3:308]
data(BCI.env.coarse)
data.env <- BCI.env.coarse[10:15]

zeta.gam <- Zeta.gam(data.spec, data.env, sam = 100, order = 3)
summary(zeta.gam)
dev.new()
plot(zeta.gam)

zeta.gam <- Zeta.gam(data.spec, data.env, xy, sam = 100, order = 3)
summary(zeta.gam)
dev.new()
plot(zeta.gam)

##########

data(Marion.species)
xy <- Marion.species[1:2]
data.species <- Marion.species[3:33]
data(Marion.env)
data.env <- Marion.env[3]

zeta.gam.species <- Zeta.gam(data.species, data.env, sam = 100, order = 3)
summary(zeta.gam.species)
dev.new()
plot(zeta.gam.species)

zeta.gam.species <- Zeta.gam(data.species, data.env, xy, sam = 100, order = 2)
summary(zeta.gam.species)
dev.new()
plot(zeta.gam.species)
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline}}, \code{\link{Zeta.order}}, \code{\link{Zeta.lm}}
}

