% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2dloon.R
\name{density_2d_loon}
\alias{density_2d_loon}
\title{Density plot in 2d using the interactive loon package}
\usage{
density_2d_loon(
  zargs,
  ngrids = 25,
  ccol = NULL,
  color = NULL,
  clwd = NULL,
  lwd = NULL,
  linewidth = 1,
  showLabels = FALSE,
  showScales = FALSE,
  showGuides = FALSE,
  linkingGroup = NULL,
  baseplot = NULL,
  parent = NULL,
  group... = NULL,
  ...
)
}
\arguments{
\item{zargs}{The argument list as passed from \code{\link{zenplot}()}}

\item{ngrids}{Number of grid points in each direction. Can be scalar or
a length-2 integer vector.}

\item{ccol}{A vector (which is then recycled to the appropriate length)
giving the color of the contours}

\item{color}{Colour used fill if ccol is NULL, a grey palette is used otherwise.}

\item{clwd}{A vector (which is then recycled to the appropriate length)
giving the line widths of the contours}

\item{lwd}{Line width used only when clwd = NULL}

\item{linewidth}{Line width used when both  clwd and lwd are NULL, value of 1 used otherwise.}

\item{showLabels}{Logical determining whether axis labels are displayed}

\item{showScales}{Logical determining whether scales are displayed}

\item{showGuides}{Logical determining whether the background guidelines are displayed}

\item{linkingGroup}{The initial linking group}

\item{baseplot}{If non-null the base plot on which the plot should be layered}

\item{parent}{The tk parent for this loon plot widget}

\item{group...}{A list of arguments passed to group_2d_loon (or NULL)}

\item{...}{Additional parameters passed to loon::l_layer_line()}
}
\value{
invisible()
}
\description{
Density plot in 2d using the interactive loon package
}
\seealso{
Other default 2d plot functions using the interactive loon package: 
\code{\link{arrow_2d_loon}()},
\code{\link{axes_2d_loon}()},
\code{\link{group_2d_loon}()},
\code{\link{label_2d_loon}()},
\code{\link{points_2d_loon}()},
\code{\link{rect_2d_loon}()}

Other default 2d plot functions: 
\code{\link{arrow_2d_graphics}()},
\code{\link{arrow_2d_grid}()},
\code{\link{arrow_2d_loon}()},
\code{\link{axes_2d_graphics}()},
\code{\link{axes_2d_grid}()},
\code{\link{axes_2d_loon}()},
\code{\link{density_2d_graphics}()},
\code{\link{density_2d_grid}()},
\code{\link{extract_2d}()},
\code{\link{group_2d_graphics}()},
\code{\link{group_2d_grid}()},
\code{\link{group_2d_loon}()},
\code{\link{label_2d_graphics}()},
\code{\link{label_2d_grid}()},
\code{\link{label_2d_loon}()},
\code{\link{points_2d_graphics}()},
\code{\link{points_2d_grid}()},
\code{\link{points_2d_loon}()},
\code{\link{qq_2d_graphics}()},
\code{\link{qq_2d_grid}()},
\code{\link{rect_2d_graphics}()},
\code{\link{rect_2d_grid}()},
\code{\link{rect_2d_loon}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 2d plot functions}
\concept{default 2d plot functions using the interactive loon package}
