% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_satisfaction_ratings.R
\name{get_satisfaction_ratings}
\alias{get_satisfaction_ratings}
\title{Get Ticket Satisfaction Ratings}
\usage{
get_satisfaction_ratings(
  email_id,
  token,
  subdomain,
  start_time,
  rating_type = "received"
)
}
\arguments{
\item{email_id}{Zendesk Email Id (username).}

\item{token}{Zendesk API token.}

\item{subdomain}{Your organization's Zendesk sub-domain.}

\item{start_time}{String with a date or datetime to get all
tickets modified after that date.}

\item{rating_type}{String that specifies whether you want to see all
received ratings, offered ratings, or unoffered ratings.}
}
\value{
a Data Frame containing all tickets, satisfaction ratings,
and the comments.
}
\description{
This function takes your Email Id, authentication token,
sub-domain and start time as parameters and gets all the
satisfaction ratings for tickets which have been received
on or after the start time parameter. By default each page returns
100 unique tickets and a next page url value which stores a
pointer to the next page (by updating the start time parameter). After
getting the first page this function will then loop through all subsequent
pages until there are none left.
}
\details{
It's not a good practice to write down these authentication
parameters in your code. There are various methods and
packages available that are more secure; this package
doesn't require you to use any one in particular.

The start time parameter should be in 'UTC' format as
Zendesk uses the 'UTC' time zone when retrieving tickets
after the start time. For example, the US Eastern Time Zone
is currently four hours behind UTC. If one wanted to get tickets
starting on August 1 at 12 am, you would need to enter
"2020-08-01 04:00:00". The user must do proper adjustment
to accommodate the time zone difference, if desired.

rating_type allows you to get the satisfaction ratings, or, to see
the tickets where a user was offered the opportunity to respond and
did not, or to see the tickets where a user was not offered the
survey. By default it will do received.
}
\examples{
\dontrun{
ratings <- get_satisfaction_ratings(email_id, token, subdomain,
  start_time = "2021-01-31 00:00:00", rating_type = "received")
)
}
}
\references{
\url{https://developer.zendesk.com/api-reference/
ticketing/ticket-management/satisfaction_ratings/}
}
