% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{z.stats}
\alias{z.stats}
\title{Get error summary statistics for any given compressibility correlation}
\usage{
z.stats(correlation = "DAK", pprRange = "lp", interval = "coarse")
}
\arguments{
\item{correlation}{identifier. Can be "HY", "DAK", "DPR" "N10", "SH"}

\item{pprRange}{low (lp) or high (hp) chart area of the Standing-Katz chart}

\item{interval}{quality of the Ppr scale. Coarse: every 1.0; Fine: every 0.5}
}
\description{
A quick way to show an error summary between any of the indicated correlations and
the Standing-Katz chart
}
\examples{
# error statistics for the Dranchuk-AbouKassem correlation
z.stats("DAK")

# error statistics for Hall-Yarborough correlation at steps of 0.5 in Ppr
z.stats("HY", interval = "fine")
}
