% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/button.R
\name{buttonGroupInput}
\alias{buttonGroupInput}
\alias{updateButtonGroupInput}
\title{Button group inputs}
\usage{
buttonGroupInput(id, choices = NULL, values = choices, ...)

updateButtonGroupInput(id, choices = NULL, values = choices,
  enable = NULL, disable = NULL,
  session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{choices}{A character vector specifying the labels for each button in
the group.}

\item{values}{A vector of values specifying the values of each button in the
group, defaults to \code{labels}.}

\item{...}{Additional named arguments passed as HTML attributes to the parent
element.}

\item{enable}{One of \code{values} indicating individual buttons to enable or
\code{TRUE} to enable the entire input, defaults to \code{NULL}.}

\item{disable}{One of \code{values} indicating individual buttons to disable or
\code{TRUE} to disable the entire input, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
A set of buttons with custom values.
}
\examples{

### Default input

buttonGroupInput(
  id = "group1",
  choices = c("Once", "Twice", "Thrice"),
  values = c(1, 2, 3)
)

### Styling the button group

buttonGroupInput(
  id = "group2",
  choices = c("Button 1", "Button 2", "Button 3")
) \%>\%
  background("blue") \%>\%
  width("1/3")

}
\seealso{
Other inputs: \code{\link{buttonInput}},
  \code{\link{checkbarInput}}, \code{\link{checkboxInput}},
  \code{\link{chipInput}}, \code{\link{fileInput}},
  \code{\link{formInput}}, \code{\link{listGroupInput}},
  \code{\link{menuInput}}, \code{\link{navInput}},
  \code{\link{radioInput}}, \code{\link{radiobarInput}},
  \code{\link{rangeInput}}, \code{\link{selectInput}},
  \code{\link{textInput}}
}
\concept{inputs}
