% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorate.R
\name{decorate.data.frame}
\alias{decorate.data.frame}
\title{Decorate Data Frame}
\usage{
\method{decorate}{data.frame}(
  x,
  meta = NULL,
  ...,
  persistence = getOption("yamlet_persistence", TRUE)
)
}
\arguments{
\item{x}{data.frame}

\item{meta}{file path for corresponding yaml metadata, or a yamlet; an attempt will be made to guess the file path if x has a 'source' attribute}

\item{...}{passed to \code{\link{decorate.list}}}

\item{persistence}{whether to coerce decorated columns to 'dvec' where suitable method exists}
}
\value{
class 'decorated' 'data.frame'
}
\description{
Decorates a data.frame. Expects metadata in yamlet
format, and loads it onto columns as attributes.
}
\details{
As of v0.8.8, the data.frame method for decorate()
coerces affected columns using \code{\link{as_dvec}}
if \code{persistence} is true and a suitable method 
exists.  'vctrs' methods are implemented for class 
\code{dvec} to help attributes persist during 
tidyverse operations. Details are described in
\code{\link{c.dvec}}. Disable this functionality
with \code{options(yamlet_persistence = FALSE)}.
}
\examples{

# find data path
library(csv)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
file
dat <- as.csv(file) # dat now has 'source' attribute

# use source attribute to find metadata 
a <- decorate(as.csv(file))

# supply metadata path (or something close) explicitly
b <- decorate(dat, meta = file)

# these are equivalent
stopifnot(identical(a, b))
}
\seealso{
decorate.list

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{desolve.decorated}()},
\code{\link{enscript.default}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}

Other decorate: 
\code{\link{as_decorated}()},
\code{\link{as_decorated.default}()},
\code{\link{decorate}()},
\code{\link{decorate.character}()},
\code{\link{decorate.list}()},
\code{\link{decorate_groups}()},
\code{\link{decorate_groups.data.frame}()},
\code{\link{decorations}()},
\code{\link{decorations.data.frame}()},
\code{\link{decorations_groups}()},
\code{\link{decorations_groups.data.frame}()},
\code{\link{group_by_decorations}()},
\code{\link{group_by_decorations.data.frame}()},
\code{\link{redecorate}()}
}
\concept{decorate}
\concept{interface}
