% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_units.R
\name{append_units.data.frame}
\alias{append_units.data.frame}
\title{Append Units for Data Frame}
\usage{
\method{append_units}{data.frame}(x, ...)
}
\arguments{
\item{x}{data.frame}

\item{...}{named arguments passed to default method, un-named are columns to alter scope}
}
\value{
data.frame
}
\description{
Appends units for data.frame.
For finer control, consider applying
\code{\link{append_units.default}}
to individual columns.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
file \%>\% decorate \%>\% explicit_guide \%>\% append_units \%>\% decorations(Age, glyco)
file \%>\% decorate \%>\% explicit_guide \%>\% append_units(glyco) \%>\% decorations(Age, glyco)
}
\seealso{
Other labels: 
\code{\link{alias.data.frame}()},
\code{\link{append_units}()},
\code{\link{append_units.default}()},
\code{\link{drop_title}()},
\code{\link{drop_title.decorated}()},
\code{\link{drop_title.default}()},
\code{\link{drop_title.dvec}()},
\code{\link{make_title}()},
\code{\link{make_title.decorated}()},
\code{\link{make_title.default}()},
\code{\link{make_title.dvec}()},
\code{\link{sub_units}()}
}
\concept{labels}
\keyword{internal}
