% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_res.R
\name{io_res.decorated}
\alias{io_res.decorated}
\title{Export Resolved Table}
\usage{
\method{io_res}{decorated}(x, file = "", ...)
}
\arguments{
\item{x}{decorated; passed to \code{\link{io_csv.data.frame}}}

\item{file}{passed to \code{\link{io_csv.data.frame}}}

\item{...}{passed to \code{\link{io_csv.character}} and \code{\link{desolve.decorated}}}
}
\value{
decorated (invisible)
}
\description{
Exports a documented table. "Desolves" attributes
to standard form, then writes data and metadata to storage.
A short-cut for \code{(io_csv(desolve(x))}.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- io_res(file)
tmp <- tempfile(fileext = '.csv')
io_res(x, tmp)
a <- io_csv(tmp, source = FALSE)
b <- io_csv(file, source = FALSE)
stopifnot(identical(a, b))
}
\seealso{
Other io: 
\code{\link{io_csv}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res}()},
\code{\link{io_res.character}()},
\code{\link{io_table}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{scripted.default}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{io}
\keyword{internal}
