% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desolve.R
\name{desolve.decorated}
\alias{desolve.decorated}
\title{Desolve Guide for Decorated}
\usage{
\method{desolve}{decorated}(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed to \code{\link{implicit_guide}} and \code{\link{classified}}}
}
\value{
decorated
}
\description{
Un-resolves explicit usage of default key 'guide' to
implicit usage for decorated class.
Simply calls \code{\link{unclassified}}
followed by \code{\link{implicit_guide}}.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)
x \%>\% resolve \%>\% decorations(Age, glyco, Race)
x \%>\% resolve(glyco, Race) \%>\% desolve \%>\% decorations(Age, glyco, Race)
}
\seealso{
Other resolve: 
\code{\link{desolve}()},
\code{\link{resolve.decorated}()},
\code{\link{resolve}()}

Other interface: 
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.default}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{resolve}
