% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{to_yamlet.character}
\alias{to_yamlet.character}
\title{Coerce Character to Yamlet Storage Format}
\usage{
\method{to_yamlet}{character}(x, block = FALSE, ...)
}
\arguments{
\item{x}{character}

\item{block}{whether to write block scalars}

\item{...}{ignored}
}
\value{
length-one character, never NA, no names
}
\description{
Coerces character to yamlet storage format.
Named character is processed as a named list.
NA_character_ is is stored as unquoted NA
and read back as NA by \code{\link{as_yam.character}}.
Use quoted "NA" or 'NA' to store the literal string,
which will be read back as a string by \code{\link{as_yam.character}}.
}
\details{
If block is TRUE, an attempt will be made
to represent character strings as literal
block scalars if they contain
newlines (experimental in yamlet >= 0.8).
}
\examples{
to_yamlet('foo')
to_yamlet(c('a','b'))
to_yamlet(c(a = 'a',b = 'b'))
to_yamlet(c(no = 'n', yes = 'y'))
to_yamlet(NA)
to_yamlet("NA")
}
\seealso{
Other to_yamlet: 
\code{\link{to_yamlet.NULL}()},
\code{\link{to_yamlet.default}()},
\code{\link{to_yamlet.list}()},
\code{\link{to_yamlet.numeric}()},
\code{\link{to_yamlet.yamlet}()},
\code{\link{to_yamlet}()}
}
\concept{to_yamlet}
\keyword{internal}
