% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/util.R
\name{NormExpr}
\alias{NormExpr}
\title{Remove the cis-effects of copy number alterations on gene expression}
\usage{
NormExpr(expr, cna.logr, gene, type = "gp", debug = FALSE,
  show.plot = FALSE, show.norm = TRUE)
}
\arguments{
\item{expr}{A matrix of gene expression values where
each row corresponds to a patient and each column is a gene.}

\item{cna.logr}{A matrix of copy number alterations log2 ratio
where each row corresponds to a patient and each column is a gene.}

\item{gene}{A character vector of gene HGNC symbols,
default for all genes with both gene expression and
copy number log2 ratio data}

\item{type}{A character, either Gaussian process regression  ("gp") or
suppor vector machine regression ("svm")}

\item{debug}{Logical, specifying whether debug information should be printed}

\item{show.plot}{Logical, specifying whether to plot the orginal expression
and the normalized expression for a gene}

\item{show.norm}{Logical, specifying whether to plot the express of
a gene after normalization, only used when \code{show.plot = TRUE}.}
}
\value{
The normalized expression matrix
}
\description{
Remove the cis-effects of copy number alterations on gene expression
}
\examples{
data(cna.logr, expr)
expr.norm = NormExpr(cna.logr, expr, gene="PTEN")
}

