/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.MutablePropertySet;
import org.apache.poi.hpsf.MutableSection;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class WriteAuthorAndTitle {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Usage: " + WriteAuthorAndTitle.class.getName() + " originPOIFS destinationPOIFS");
            System.exit(1);
        }
        String srcName = args[0];
        String dstName = args[1];
        POIFSReader r = new POIFSReader();
        ModifySICopyTheRest msrl = new ModifySICopyTheRest(dstName);
        r.registerListener((POIFSReaderListener)msrl);
        r.read((InputStream)new FileInputStream(srcName));
        msrl.close();
    }

    static class ModifySICopyTheRest
    implements POIFSReaderListener {
        String dstName;
        OutputStream out;
        POIFSFileSystem poiFs;
        private final Map paths = new HashMap();

        public ModifySICopyTheRest(String dstName) {
            this.dstName = dstName;
            this.poiFs = new POIFSFileSystem();
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            Throwable t;
            String name;
            POIFSDocumentPath path;
            block10: {
                path = event.getPath();
                name = event.getName();
                DocumentInputStream stream = event.getStream();
                t = null;
                try {
                    if (PropertySet.isPropertySetStream((InputStream)stream)) {
                        PropertySet ps = null;
                        try {
                            ps = PropertySetFactory.create((InputStream)stream);
                        }
                        catch (NoPropertySetStreamException ex) {
                            // empty catch block
                        }
                        if (ps.isSummaryInformation()) {
                            this.editSI(this.poiFs, path, name, ps);
                        } else {
                            this.copy(this.poiFs, path, name, ps);
                        }
                        break block10;
                    }
                    this.copy(this.poiFs, event.getPath(), event.getName(), stream);
                }
                catch (MarkUnsupportedException ex) {
                    t = ex;
                }
                catch (IOException ex) {
                    t = ex;
                }
                catch (WritingNotSupportedException ex) {
                    t = ex;
                }
            }
            if (t != null) {
                throw new HPSFRuntimeException("Could not read file \"" + path + "/" + name + "\". Reason: " + Util.toString((Throwable)t));
            }
        }

        public void editSI(POIFSFileSystem poiFs, POIFSDocumentPath path, String name, PropertySet si) throws WritingNotSupportedException, IOException {
            DirectoryEntry de = this.getPath(poiFs, path);
            MutablePropertySet mps = new MutablePropertySet(si);
            MutableSection s = (MutableSection)mps.getSections().get(0);
            s.setProperty(4, 30L, (Object)"Rainer Klute");
            s.setProperty(2, 31L, (Object)"Test");
            InputStream pss = mps.toInputStream();
            de.createDocument(name, pss);
        }

        public void copy(POIFSFileSystem poiFs, POIFSDocumentPath path, String name, PropertySet ps) throws WritingNotSupportedException, IOException {
            DirectoryEntry de = this.getPath(poiFs, path);
            MutablePropertySet mps = new MutablePropertySet(ps);
            de.createDocument(name, mps.toInputStream());
        }

        public void copy(POIFSFileSystem poiFs, POIFSDocumentPath path, String name, DocumentInputStream stream) throws IOException {
            int c;
            DirectoryEntry de = this.getPath(poiFs, path);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((c = stream.read()) != -1) {
                out.write(c);
            }
            stream.close();
            out.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            de.createDocument(name, (InputStream)in);
        }

        public void close() throws FileNotFoundException, IOException {
            this.out = new FileOutputStream(this.dstName);
            this.poiFs.writeFilesystem(this.out);
            this.out.close();
        }

        public DirectoryEntry getPath(POIFSFileSystem poiFs, POIFSDocumentPath path) {
            try {
                String s = path.toString();
                DirectoryEntry de = (DirectoryEntry)this.paths.get(s);
                if (de != null) {
                    return de;
                }
                int l = path.length();
                if (l == 0) {
                    de = poiFs.getRoot();
                } else {
                    de = this.getPath(poiFs, path.getParent());
                    de = de.createDirectory(path.getComponent(path.length() - 1));
                }
                this.paths.put(s, de);
                return de;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                throw new RuntimeException(ex.toString());
            }
        }
    }
}

