% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlr_format.R
\name{xlr_format}
\alias{xlr_format}
\alias{xlr_format_numeric}
\title{Specify formatting options for \verb{xlr_*} types}
\usage{
xlr_format(
  font_size = 11,
  font_colour = "black",
  font = "calibri",
  text_style = NULL,
  border = NULL,
  border_colour = "black",
  border_style = "thin",
  background_colour = NULL,
  halign = "left",
  valign = "top",
  wrap_text = FALSE,
  text_rotation = 0L,
  indent = 0L,
  col_width = 10,
  ...
)

xlr_format_numeric(
  font_size = 11,
  font_colour = "black",
  font = "calibri",
  text_style = NULL,
  border = NULL,
  border_colour = "black",
  border_style = "thin",
  background_colour = NULL,
  halign = "right",
  valign = "bottom",
  wrap_text = FALSE,
  text_rotation = 0L,
  indent = 0L,
  col_width = 10
)
}
\arguments{
\item{font_size}{A numeric. The font size, must be greater than 0.}

\item{font_colour}{String. The colour of text in the cell. Must be one of \code{colours()}
or a valid hex colour beginning with \code{"#"}.}

\item{font}{String. The name of a font. This is not validated.}

\item{text_style}{the text styling. You can pass a vector of text
decorations or a single string. The options for text style are \code{"bold"}, \code{"strikeout"},
\code{"italic"}, \code{"underline"},\code{"underline2"} (double underline), \code{"accounting"} (accounting
underline), \code{"accounting2"} (double accounting underline). See Details.}

\item{border}{the cell border. You can pass a vector of \code{"top"}, \code{"bottom"}, \code{"left"},
\code{"right"} or a single string to set the borders that you want.}

\item{border_colour}{Character. The colour of border. Must be the same length as the number of
sides specified in \code{border}. Each element must be one of \code{colours()}
or a valid hex colour beginning with \code{"#"}.}

\item{border_style}{Border line style vector the same length as the number of
sides specified in \code{border}. The list of styles are \code{"none"}, \code{"thin"}, \code{"medium"},
\code{"dashed"}, \code{"dotted"}, \code{"thick"}, \code{"double"}, \code{"hair"}, "\verb{mediumDashed"}, \code{"dashDot"},
\code{"mediumDashDot"}, \code{"dashDotDot"}, \code{"mediumDashDot"}, \code{"dastDotDot"}, \code{"mediumDashDotDot"},
\code{"slantDashDosh"}. See \link[openxlsx]{createStyle} for more details.}

\item{background_colour}{Character. Set the background colour for the cell. Must be one of
\code{colours()} or a valid hex colour beginning with \code{"#"}.}

\item{halign}{the horizontal alignment of cell contents. Must be either
\code{"left"}, \code{"right"}, \code{"center"} or "\verb{justify"}.}

\item{valign}{the vertical alignment of cell contents. Must be either
\code{"top"}, \code{"center"}, or \code{"bottom"}.}

\item{wrap_text}{Logical. If \code{TRUE} cell contents will rap to fit in the column.}

\item{text_rotation}{Integer. Rotation of text in degrees. Must be an integer between -90 and
90.}

\item{indent}{Integer. The number of indent positions, must be an integer between 0 and 250.}

\item{col_width}{Numeric. The column width.}

\item{...}{Dots. For future expansions. Must be empty.}
}
\value{
a \code{xlr_format} S3 class.
}
\description{
This function is a utility to work with \code{openxlxs}'s \link[openxlsx]{createStyle}, and work
with styles between them. \code{\link[=xlr_format_numeric]{xlr_format_numeric()}} is an alias for \code{\link[=xlr_format]{xlr_format()}} but with different
default values.
}
\details{
\subsection{Text styling}{

For text styling you can pass either one of the options or options in a
vector. For example if you would like to have text that is \strong{bold} and
\emph{italised} then set:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fmt <- xlr_format(text_style = c("bold", "italic"))
}\if{html}{\out{</div>}}

If you would like to the text to be only \strong{bold} then:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fmt <- xlr_format(text_style = "bold")
}\if{html}{\out{</div>}}
}

\subsection{Border styling}{

The three arguments to create border styling are \code{border}, \code{border_colour},
and \code{border_style}. They each take either a vector, where you specify to
change what borders to have in each cell and what they look like. To specify
that you want a border around a cell, use \code{border}, you need to pass a vector
of what sides you want to have a border (or a single element if it's only one
side). For example:
\itemize{
\item \code{"top"} the top border
\item \code{"left"} the left border
\item \code{c("bottom", "right")} the top and bottom border
\item \code{c("left", "right", "bottom")} the left, right and bottom borders
\item \code{c("top","right","bottom","left")} the borders for all sides of the cells
}

Based on this you can use \code{border_colour} to set the border colours. If you
want all the same border colour, just pass a character representing the colour
you want (e.g. set \code{border_colour = "blue"} if you'd like all borders to be
blue). Alternatively you can pass a vector the same length as the vector
that you passed to \code{border}, with the location specifying the colour. For example,
if you set:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fmt <- xlr_format(border = c("left", "top"),
                    border_colour = c("blue","red"))
}\if{html}{\out{</div>}}

the top border will be red, and the left border will be blue. You set the pattern
in the same way for \code{border_style}. Alternatively if you only wanted it to
be dashed with default colours. You'd set:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fmt <- xlr_format(border = c("left", "top"),
                  border_style = "dashed")
}\if{html}{\out{</div>}}
}
}
\examples{
library(xlr)
# You can initialise a xlr_format, it comes with a list of defaults
bf <- xlr_format()
# It outputs what the style looks like
bf
# You can update the format by defining a new format
bf <- xlr_format(font_size = 11,
                  # not that font is not validated
                  font = "helvetica")
# The main use of xlr_format is to change the format of a vector of
# a xlr type
bd <- xlr_numeric(1:200,
                  dp = 1,
                  style = bf)
# You can also use it to change the styles of an xlr_table, this only
# affect the format in `Excel`
bt <- xlr_table(mtcars, "A clever title", "A useful footnote")
bt <- bt |>
      update_theme(footnote_format = xlr_format(font_size = 7))
}
\seealso{
\itemize{
\item \code{\link[=is_xlr_format]{is_xlr_format()}} to test if an R object is a \code{xlr_format}
\item \code{\link[=xlr_table]{xlr_table()}} to use xlr formats
}
}
