% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_annotate_filenames.R
\name{xgx_annotate_filenames}
\alias{xgx_annotate_filenames}
\title{Append filenames to bottom of the plot}
\usage{
xgx_annotate_filenames(dirs, hjust = 0.5, color = "black", size = 11)
}
\arguments{
\item{dirs}{list containing directories and filenames.  It must contain 
five fields
\enumerate{
\item parent_dir  = Parent directory containing the Rscript and the Results 
folder
\item rscript_dir = Subdirectory ofparent_dir that contains the Rscript 
used to generate the figure
\item rscript_name= Name of the Rscript used to generate the figure
\item results_dir = Subdirectory ofparent_dir where the figure is stored
\item filename    = Filename
}}

\item{hjust}{horizontal justification of the caption}

\item{color}{font color for caption, default black}

\item{size}{font size for caption, default 11}
}
\value{
None
}
\description{
\code{xgx_annotate_filenames} appends file details to the bottom of a plot 
using the plot caption option. 
File details to append include the parent directory, the path of the R 
script which generated the plot, 
and the path of the plot.
}
\examples{
dirs <- list(parent_dir = "/your/parent/path/",
             rscript_dir = "./Rscripts/",
             rscript_name = "Example.R",
             results_dir = "./Results/",
             filename = "your_file_name.png")
data <- data.frame(x = 1:1000, y = rnorm(1000))
ggplot2::ggplot(data = data, ggplot2::aes(x = x, y = y)) +
  ggplot2::geom_point() +
  xgx_annotate_filenames(dirs)

}
