# Generated by inst/scripts/generate_theme_functions.R: do not edit by hand

#' @param text_color Text Color. Defaults to #000. Modifies the `body` element.
#'   The value of this variable is also stored as a CSS variable that can be
#'   referenced with `var(--text_color)` in any argument of a style function or
#'   in custom CSS.
#' @param header_color Header Color. Defaults to #000. Modifies the
#'   `h1, h2, h3` elements. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--header-color)` in any argument
#'   of a style function or in custom CSS.
#' @param background_color Slide Background Color. Defaults to #FFF. Modifies
#'   the `.remark-slide-content` class. The value of this variable is also
#'   stored as a CSS variable that can be referenced with
#'   `var(--background-color)` in any argument of a style function or in custom
#'   CSS.
#' @param link_color Link Color. Defaults to rgb(249, 38, 114). Modifies the
#'   `a, a > code` elements. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--link-color)` in any argument
#'   of a style function or in custom CSS.
#' @param text_bold_color Bold Text Color. Defaults to `NULL`. Modifies the
#'   `strong` element. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--text-bold-color)` in any
#'   argument of a style function or in custom CSS.
#' @param text_slide_number_color Slide Number Color. Defaults to
#'   `inverse_background_color`. Modifies the `.remark-slide-number` class.
#' @param padding Slide Padding in `top right [bottom left]` format. Defaults
#'   to 16px 64px 16px 64px. Modifies the `.remark-slide-content` class.
#'   Accepts CSS
#'   [padding](https://developer.mozilla.org/en-US/docs/Web/CSS/padding)
#'   property values.
#' @param background_image Background image applied to each *and every* slide.
#'   Set `title_slide_background_image = "none"` to remove the background image
#'   from the title slide. Defaults to `NULL`. Modifies the
#'   `.remark-slide-content` class.
#' @param background_size Background image size, requires `background_image` to
#'   be set. If `background_image` is set, `background_size` will default to
#'   `cover` so the background fills the screen. If both `background_image` and
#'   `background_position` are set, will default to 100 percent. Defaults to
#'   `NULL`. Modifies the `.remark-slide-content` class. Accepts CSS
#'   [background-size](https://developer.mozilla.org/en-US/docs/Web/CSS/background-size)
#'   property values.
#' @param background_position Background image position, requires
#'   `background_image` to be set, and it is recommended to adjust
#'   `background_size`. Defaults to `NULL`. Modifies the
#'   `.remark-slide-content` class. Accepts CSS
#'   [background-position](https://developer.mozilla.org/en-US/docs/Web/CSS/background-position)
#'   property values.
#' @param code_highlight_color Code Line Highlight. Defaults to
#'   rgba(255,255,0,0.5). Modifies the `.remark-code-line-highlighted` class.
#'   The value of this variable is also stored as a CSS variable that can be
#'   referenced with `var(--code-highlight-color)` in any argument of a style
#'   function or in custom CSS.
#' @param code_inline_color Inline Code Color. Defaults to #000. Modifies the
#'   `.remark-inline-code` class.
#' @param code_inline_background_color Inline Code Background Color. Defaults
#'   to `NULL`. Modifies the `.remark-inline-code` class.
#' @param code_inline_font_size Inline Code Text Font Size. Defaults to 1em.
#'   Modifies the `.remark-inline-code` class. Accepts CSS
#'   [font-size](https://developer.mozilla.org/en-US/docs/Web/CSS/font-size)
#'   property values. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--code-inline-font-size)` in any
#'   argument of a style function or in custom CSS.
#' @param inverse_background_color Inverse Background Color. Defaults to
#'   #272822. Modifies the `.inverse` class. The value of this variable is also
#'   stored as a CSS variable that can be referenced with
#'   `var(--inverse-background-color)` in any argument of a style function or
#'   in custom CSS.
#' @param inverse_text_color Inverse Text Color. Defaults to #d6d6d6. Modifies
#'   the `.inverse` class. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--inverse-text-color)` in any
#'   argument of a style function or in custom CSS.
#' @param inverse_text_shadow Enables Shadow on text of inverse slides.
#'   Defaults to `FALSE`. Modifies the `.inverse` class.
#' @param inverse_header_color Inverse Header Color. Defaults to #f3f3f3.
#'   Modifies the `.inverse h1, .inverse h2, .inverse h3` classes. The value of
#'   this variable is also stored as a CSS variable that can be referenced with
#'   `var(--inverse-header-color)` in any argument of a style function or in
#'   custom CSS.
#' @param inverse_link_color Inverse Link Color. Defaults to `link_color`.
#'   Modifies the `.inverse a, .inverse a > code` classes. The value of this
#'   variable is also stored as a CSS variable that can be referenced with
#'   `var(--inverse-link-color)` in any argument of a style function or in
#'   custom CSS.
#' @param title_slide_text_color Title Slide Text Color. Defaults to
#'   `inverse_text_color`. Modifies the `.title-slide` class. The value of this
#'   variable is also stored as a CSS variable that can be referenced with
#'   `var(--title-slide-text-color)` in any argument of a style function or in
#'   custom CSS.
#' @param title_slide_background_color Title Slide Background Color. Defaults
#'   to `inverse_background_color`. Modifies the `.title-slide` class. The
#'   value of this variable is also stored as a CSS variable that can be
#'   referenced with `var(--title-slide-background-color)` in any argument of a
#'   style function or in custom CSS.
#' @param title_slide_background_image Title Slide Background Image URL.
#'   Defaults to `NULL`. Modifies the `.title-slide` class.
#' @param title_slide_background_size Title Slide Background Image Size,
#'   defaults to "cover" if background image is set. Defaults to `NULL`.
#'   Modifies the `.title-slide` class. Accepts CSS
#'   [background-size](https://developer.mozilla.org/en-US/docs/Web/CSS/background-size)
#'   property values.
#' @param title_slide_background_position Title Slide Background Image
#'   Position. Defaults to `NULL`. Modifies the `.title-slide` class. Accepts
#'   CSS
#'   [background-position](https://developer.mozilla.org/en-US/docs/Web/CSS/background-position)
#'   property values.
#' @param footnote_color Footnote text color (if `NA`, then it will be the same
#'   color as `text_color`). Defaults to `NULL`. Modifies the `.footnote`
#'   class.
#' @param footnote_font_size Footnote font size. Defaults to 0.9em. Modifies
#'   the `.footnote` class. Accepts CSS
#'   [font-size](https://developer.mozilla.org/en-US/docs/Web/CSS/font-size)
#'   property values.
#' @param footnote_position_bottom Footnote location from bottom of screen.
#'   Defaults to 60px. Modifies the `.footnote` class. Accepts CSS
#'   [position](https://developer.mozilla.org/en-US/docs/Web/CSS/position_value)
#'   property values.
#' @param left_column_subtle_color Left Column Text (not last). Defaults to
#'   #777. Modifies the `.left-column h2, .left-column h3` classes.
#' @param left_column_selected_color Left Column Current Selection. Defaults to
#'   #000. Modifies the
#'   `.left-column h2:last-of-type, .left-column h3:last-child` classes.
#' @param blockquote_left_border_color Blockquote Left Border Color. Defaults
#'   to lightgray. Modifies the `blockquote` element.
#' @param table_border_color Table top/bottom border. Defaults to #666.
#'   Modifies the `table: border-top, border-bottom` elements.
#' @param table_row_border_color Table row inner bottom border. Defaults to
#'   #ddd. Modifies the `table thead th: border-bottom` elements.
#' @param table_row_even_background_color Table Even Row Background Color.
#'   Defaults to #eee. Modifies the `thead, tfoot, tr:nth-child(even)`
#'   elements.
#' @param base_font_size Base Font Size for All Slide Elements (must be `px`).
#'   Defaults to 20px. Modifies the `html` element. The value of this variable
#'   is also stored as a CSS variable that can be referenced with
#'   `var(--base-font-size)` in any argument of a style function or in custom
#'   CSS.
#' @param text_font_size Slide Body Text Font Size. Defaults to 1rem. Modifies
#'   the `.remark-slide-content` class. Accepts CSS
#'   [font-size](https://developer.mozilla.org/en-US/docs/Web/CSS/font-size)
#'   property values. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--text-font-size)` in any
#'   argument of a style function or in custom CSS.
#' @param header_h1_font_size h1 Header Text Font Size. Defaults to 2.75rem.
#'   Modifies the `.remark-slide-content h1` class. Accepts CSS
#'   [font-size](https://developer.mozilla.org/en-US/docs/Web/CSS/font-size)
#'   property values. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--header-h1-font-size)` in any
#'   argument of a style function or in custom CSS.
#' @param header_h2_font_size h2 Header Text Font Size. Defaults to 2.25rem.
#'   Modifies the `.remark-slide-content h2` class. Accepts CSS
#'   [font-size](https://developer.mozilla.org/en-US/docs/Web/CSS/font-size)
#'   property values. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--header-h2-font-size)` in any
#'   argument of a style function or in custom CSS.
#' @param header_h3_font_size h3 Header Text Font Size. Defaults to 1.75rem.
#'   Modifies the `.remark-slide-content h3` class. Accepts CSS
#'   [font-size](https://developer.mozilla.org/en-US/docs/Web/CSS/font-size)
#'   property values. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--header-h3-font-size)` in any
#'   argument of a style function or in custom CSS.
#' @param header_background_auto Add background under slide title automatically
#'   for h1 header elements. If not enabled, use `class: header_background` to
#'   enable. Defaults to `FALSE`.
#' @param header_background_color Background Color for h1 Header with
#'   Background. Defaults to `header_color`. Modifies the
#'   `.remark-slide-content h1` class. The value of this variable is also
#'   stored as a CSS variable that can be referenced with
#'   `var(--header-background-color)` in any argument of a style function or in
#'   custom CSS.
#' @param header_background_text_color Text Color for h1 Header with
#'   Background. Defaults to `background_color`. Modifies the
#'   `.remark-slide-content h1` class. The value of this variable is also
#'   stored as a CSS variable that can be referenced with
#'   `var(--header-background-text-color)` in any argument of a style function
#'   or in custom CSS.
#' @param header_background_padding Padding for h1 Header with Background.
#'   Defaults to `NULL`. Modifies the `.remark-slide-content h1` class. Accepts
#'   CSS [padding](https://developer.mozilla.org/en-US/docs/Web/CSS/padding)
#'   property values.
#' @param header_background_content_padding_top Top Padding for Content in
#'   Slide with Header with Background. Defaults to 7rem. Modifies the
#'   `.remark-slide-content` class.
#' @param header_background_ignore_classes Slide Classes Where Header with
#'   Background will not be Applied. Defaults to
#'   `c('normal', 'inverse', 'title', 'middle', 'bottom')`. Modifies the
#'   `.remark-slide-content` class.
#' @param text_slide_number_font_size Slide Number Text Font Size. Defaults to
#'   0.9rem. Modifies the `.remark-slide-number` class. Accepts CSS
#'   [font-size](https://developer.mozilla.org/en-US/docs/Web/CSS/font-size)
#'   property values.
#' @param text_font_google Use `google_font()` to specify body font. Defaults
#'   to `NULL`. Modifies the `body` element.
#' @param text_font_family Body Text Font Family (xaringan default is
#'   `'Droid Serif'`). Defaults to
#'   `xaringanthemer_font_default("text_font_family")`. Modifies the `body`
#'   element. The value of this variable is also stored as a CSS variable that
#'   can be referenced with `var(--text-font-family)` in any argument of a
#'   style function or in custom CSS.
#' @param text_font_weight Body Text Font Weight. Defaults to
#'   `xaringanthemer_font_default("text_font_weight")`. Modifies the `body`
#'   element. Accepts CSS
#'   [font-weight](https://developer.mozilla.org/en-US/docs/Web/CSS/font-weight)
#'   property values.
#' @param text_bold_font_weight Body Bold Text Font Weight. Defaults to bold.
#'   Modifies the `strong` element.
#' @param text_font_url Body Text Font URL(s). Defaults to
#'   `xaringanthemer_font_default("text_font_url")`. Modifies the
#'   `@import url()` elements.
#' @param text_font_family_fallback Body Text Font Fallbacks. Defaults to
#'   `xaringanthemer_font_default("text_font_family_fallback")`. Modifies the
#'   `body` element. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--text-font-family-fallback)` in
#'   any argument of a style function or in custom CSS.
#' @param text_font_base Body Text Base Font (Total Failure Fallback). Defaults
#'   to sans-serif. Modifies the `body` element. The value of this variable is
#'   also stored as a CSS variable that can be referenced with
#'   `var(--text-font-base)` in any argument of a style function or in custom
#'   CSS.
#' @param header_font_google Use `google_font()` to specify header font.
#'   Defaults to `NULL`. Modifies the `body` element.
#' @param header_font_family Header Font Family (xaringan default is
#'   `'Yanone Kaffeesatz'`). Defaults to
#'   `xaringanthemer_font_default("header_font_family")`. Modifies the
#'   `h1, h2, h3` elements. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--header-font-family)` in any
#'   argument of a style function or in custom CSS.
#' @param header_font_weight Header Font Weight. Defaults to
#'   `xaringanthemer_font_default("header_font_weight")`. Modifies the
#'   `h1, h2, h3` elements. Accepts CSS
#'   [font-weight](https://developer.mozilla.org/en-US/docs/Web/CSS/font-weight)
#'   property values.
#' @param header_font_family_fallback Header Font Family Fallback. Defaults to
#'   Georgia, serif. Modifies the `h1, h2, h3` elements. The value of this
#'   variable is also stored as a CSS variable that can be referenced with
#'   `var(--header-font-family-fallback)` in any argument of a style function
#'   or in custom CSS.
#' @param header_font_url Header Font URL. Defaults to
#'   `xaringanthemer_font_default("header_font_url")`. Modifies the
#'   `@import url` elements.
#' @param code_font_google Use `google_font()` to specify code font. Defaults
#'   to `NULL`. Modifies the `body` element.
#' @param code_font_family Code Font Family. Defaults to
#'   `xaringanthemer_font_default("code_font_family")`. Modifies the
#'   `.remark-code, .remark-inline-code` classes. The value of this variable is
#'   also stored as a CSS variable that can be referenced with
#'   `var(--code-font-family)` in any argument of a style function or in custom
#'   CSS.
#' @param code_font_size Code Text Font Size. Defaults to 0.9rem. Modifies the
#'   `.remark-inline` class. Accepts CSS
#'   [font-size](https://developer.mozilla.org/en-US/docs/Web/CSS/font-size)
#'   property values. The value of this variable is also stored as a CSS
#'   variable that can be referenced with `var(--code-font-size)` in any
#'   argument of a style function or in custom CSS.
#' @param code_font_url Code Font URL. Defaults to
#'   `xaringanthemer_font_default("code_font_url")`. Modifies the `@import url`
#'   elements.
#' @param code_font_family_fallback Code Font Fallback. Defaults to
#'   `xaringanthemer_font_default("code_font_family_fallback")`. Modifies the
#'   `.remark-code, .remark-inline-code` classes.
#' @param link_decoration Text decoration of links. Defaults to none. Modifies
#'   the `a, a > code` elements. Accepts CSS
#'   [text-decoration](https://developer.mozilla.org/en-US/docs/Web/CSS/text-decoration)
#'   property values.
#' @template theme_params
#' @template style-usage
#' @template style_xaringan
#' @export
style_xaringan <- function(
  text_color = "#000",
  header_color = "#000",
  background_color = "#FFF",
  link_color = "rgb(249, 38, 114)",
  text_bold_color = NULL,
  text_slide_number_color = inverse_background_color,
  padding = "16px 64px 16px 64px",
  background_image = NULL,
  background_size = NULL,
  background_position = NULL,
  code_highlight_color = "rgba(255,255,0,0.5)",
  code_inline_color = "#000",
  code_inline_background_color = NULL,
  code_inline_font_size = "1em",
  inverse_background_color = "#272822",
  inverse_text_color = "#d6d6d6",
  inverse_text_shadow = FALSE,
  inverse_header_color = "#f3f3f3",
  inverse_link_color = link_color,
  title_slide_text_color = inverse_text_color,
  title_slide_background_color = inverse_background_color,
  title_slide_background_image = NULL,
  title_slide_background_size = NULL,
  title_slide_background_position = NULL,
  footnote_color = NULL,
  footnote_font_size = "0.9em",
  footnote_position_bottom = "60px",
  left_column_subtle_color = "#777",
  left_column_selected_color = "#000",
  blockquote_left_border_color = "lightgray",
  table_border_color = "#666",
  table_row_border_color = "#ddd",
  table_row_even_background_color = "#eee",
  base_font_size = "20px",
  text_font_size = "1rem",
  header_h1_font_size = "2.75rem",
  header_h2_font_size = "2.25rem",
  header_h3_font_size = "1.75rem",
  header_background_auto = FALSE,
  header_background_color = header_color,
  header_background_text_color = background_color,
  header_background_padding = NULL,
  header_background_content_padding_top = "7rem",
  header_background_ignore_classes = c('normal', 'inverse', 'title', 'middle', 'bottom'),
  text_slide_number_font_size = "0.9rem",
  text_font_google = NULL,
  text_font_family = xaringanthemer_font_default("text_font_family"),
  text_font_weight = xaringanthemer_font_default("text_font_weight"),
  text_bold_font_weight = "bold",
  text_font_url = xaringanthemer_font_default("text_font_url"),
  text_font_family_fallback = xaringanthemer_font_default("text_font_family_fallback"),
  text_font_base = "sans-serif",
  header_font_google = NULL,
  header_font_family = xaringanthemer_font_default("header_font_family"),
  header_font_weight = xaringanthemer_font_default("header_font_weight"),
  header_font_family_fallback = "Georgia, serif",
  header_font_url = xaringanthemer_font_default("header_font_url"),
  code_font_google = NULL,
  code_font_family = xaringanthemer_font_default("code_font_family"),
  code_font_size = "0.9rem",
  code_font_url = xaringanthemer_font_default("code_font_url"),
  code_font_family_fallback = xaringanthemer_font_default("code_font_family_fallback"),
  link_decoration = "none",
  colors = NULL,
  extra_css = NULL,
  extra_fonts = NULL,
  outfile = "xaringan-themer.css"
) {
  # DO NOT EDIT - Generated from inst/scripts/generate_theme_functions.R
  force(text_font_family)
  force(text_font_weight)
  force(text_font_url)
  force(text_font_family_fallback)
  force(header_font_family)
  force(header_font_weight)
  force(header_font_url)
  force(code_font_family)
  force(code_font_url)
  force(code_font_family_fallback)

  # the defaults are google fonts
  is_default <- function(type, suffix) {
    # check if font arg value is from xaringanthemer_font_default
    var <- paste0(type, "_", suffix)
    inherits(
      get(var, envir = parent.frame(2), inherits = FALSE),
      "xaringanthemer_default"
    )
  }
  for (var in c("text", "header", "code")) {
    suffixes <- c("font_family", "font_weight", "font_url")
    if (var == "code") suffixes <- setdiff(suffixes, "font_weight")
    var_is_google <- all(vapply(suffixes, is_default, logical(1), type = var))
    var_is_google <- as.integer(var_is_google)
    r_set_font_is_google <- glue::glue("{var}_font_is_google <- {var_is_google}")
    eval(parse(text = r_set_font_is_google))
  }

  # Make sure font names are wrapped in quotes if they have spaces
  f_args <- names(formals(sys.function()))
  for (var in f_args[grepl("font_family$", f_args)]) {
    var_value <- get(var, inherits = FALSE)
    if (!is.null(var_value)) {
      eval(parse(text = paste0(var, "<-quote_elements_w_spaces(", var, ")")))
    }
  }

  # Warn if base_font_size isn't absolute
  css_abs_units <- c("cm", "mm", "Q", "in", "pc", "pt", "px")
  if (!grepl(paste(tolower(css_abs_units), collapse = "|"), tolower(base_font_size))) {
    warning(
      glue::glue(
        "Base font size '{base_font_size}' is not in absolute units. ",
        "For best results, specify the `base_font_size` using absolute CSS units: ",
        "{paste(css_abs_units, collapse = ', ')}"
      ),
      call. = FALSE,
      immediate. = TRUE
    )
  }

  # If certain colors aren't in hexadecimal it may cause problems with theme_xaringan()
  # TODO: at some point I'd rather be able to process CSS colors or variables
  colors_used_by_theme_xaringan <- list(
    background_color = background_color,
    text_color = text_color,
    header_color = header_color,
    text_bold_color = text_bold_color,
    inverse_background_color = inverse_background_color,
    inverse_text_color = inverse_text_color,
    inverse_header_color = inverse_header_color
  )
  colors_used_by_theme_xaringan <- purrr::discard(colors_used_by_theme_xaringan, is.null)
  colors_are_hex <- purrr::map_lgl(colors_used_by_theme_xaringan, check_color_is_hex, throw = NULL)

  if (any(!colors_are_hex)) {
    colors_better_as_hex <- names(colors_used_by_theme_xaringan)[!colors_are_hex]
    colors_better_as_hex <- paste(colors_better_as_hex, collapse = ", ")
    warning(
      glue::glue("Colors that will be used by `theme_xaringan()` need to be in ",
        "hexadecimal format: {colors_better_as_hex}"),
      immediate. = TRUE,
      call. = FALSE
    )
  }

  # Use font_..._google args to overwrite font args
  for (var in f_args[grepl("font_google$", f_args)]) {
    gf <- eval(parse(text = var))
    if (is.null(gf)) next
    if (!inherits(gf, "google_font")) {
      stop("`", var, "` must be set using `google_font()`.")
    }
    group <- strsplit(var, "_")[[1]][1]
    if (group == "text") {
      text_font_family <- quote_elements_w_spaces(gf$family)
      text_font_weight <- gf$weights %||% "normal"
      if (grepl(",", text_font_weight)) {
        # Use first font weight if multiple are imported
        text_font_weight <- substr(text_font_weight, 1, regexpr(",", text_font_weight)[1] - 1)
      }
      text_font_url <- gf$url
    } else {
      eval(parse(text = paste0(group, "_font_family <- quote_elements_w_spaces(gf$family)")))
      eval(parse(text = paste0(group, "_font_url <- gf$url")))
    }
    eval(parse(text = paste0(group, "_font_is_google <- 1")))
  }

  extra_font_imports <- if (is.null(extra_fonts)) "" else list2fonts(extra_fonts)
  extra_font_imports <- paste(extra_font_imports, collapse = "\n")

  # convert NA arguments to NULL
  for (var in f_args) {
    val <- eval(parse(text = var))
    if (is.null(val)) next
    val <- val[!is.na(val)]
    is_na <- length(val) == 0
    if (is_na) assign(var, NULL, envir = sys.frame(sys.nframe()))
  }

  # prepare variables for template
  body_font_family <- paste(c(text_font_family, text_font_family_fallback, text_font_base), collapse = ", ")
  background_size_fallback <- if (is.null(background_position)) "cover" else "100%"
  background_size <- background_image %??% (background_size %||% background_size_fallback)
  title_slide_background_size <- title_slide_background_size %||% (
    title_slide_background_image %??% "cover"
  )
  table_row_even_background_color <- table_row_even_background_color %||% background_color

  # stash theme settings in package env
  lapply(f_args, function(n) assign(n, get(n), envir = xaringanthemer_env))
  for (font_is_google in paste0(c("text", "code", "header"), "_font_is_google")) {
    assign(
      font_is_google,
      get(font_is_google, inherits = FALSE) == 1,
      envir = xaringanthemer_env
    )
  }

  xaringanthemer_version <- utils::packageVersion("xaringanthemer")

  # prepare header background object
  needs_leading_dot <- !grepl("^\\.", header_background_ignore_classes)
  header_background_ignore_classes[needs_leading_dot] <- paste0(
    ".",
    header_background_ignore_classes[needs_leading_dot]
  )
  header_background_ignore_classes <- purrr::map(
    header_background_ignore_classes,
    ~ list(class = .)
  )
  if (is.null(header_background_padding)) {
    slide_padding <- css_get_padding(padding)
    header_background_padding <- paste(
      "2rem", slide_padding$right, "1.5rem", slide_padding$left
    )
  }
  header_background <- list(
    auto = header_background_auto,
    background_color = header_background_color,
    text_color = header_background_text_color,
    padding = header_background_padding,
    content_padding_top = header_background_content_padding_top,
    ignore = header_background_ignore_classes
  )

  colors <- prepare_colors(colors)

  tf <- system.file("resources", "template.css", package = "xaringanthemer")
  template <- readLines(tf, warn = FALSE)
  template <- paste(template, collapse = "\n")
  x <- whisker::whisker.render(template)
  if (!is.null(extra_css)) {
    x <- c(x, style_extra_css(extra_css, outfile = NULL))
  }
  if (is.null(outfile)) {
    return(x)
  }
  writeLines(x, con = outfile)
  invisible(outfile)
}
