% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectShifts.R
\name{detectShifts}
\alias{detectShifts}
\title{Detect FOV shift}
\usage{
detectShifts(cli_path)
}
\arguments{
\item{cli_path}{a character string, path to the CLI file}
}
\value{
a data.frame with two columns containing day-to-day correlations of the brightness and blue bands
}
\description{
This function calculates day-to-day similarity of images based on the CLI file.
}
\examples{

cli_path <- system.file(package = 'xROI', 'archboldbahia-cli.jpg')

cor_mat <- detectShifts(cli_path)

plot(cor_mat$brightness.cor)
plot(cor_mat$blue.cor)

}
\keyword{FOV}
\keyword{shift}
