% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{xQTLanalyze_getTraits}
\alias{xQTLanalyze_getTraits}
\title{Identify trait genes using sentinel SNPs generated from \code{xQTLanalyze_getSentinelSnp}}
\usage{
xQTLanalyze_getTraits(
  sentinelSnpDF,
  detectRange = 1e+06,
  tissueSiteDetail = "",
  genomeVersion = "grch38",
  grch37To38 = FALSE,
  overlapWithEGene = TRUE,
  egeneDF = NULL
)
}
\arguments{
\item{sentinelSnpDF}{A data.table. Better be the results from the function "xQTLanalyze_getSentinelSnp", seven columns are required, including "rsid", "chr", "position", "pValue", "maf", "beta" and "se".}

\item{detectRange}{A integer value. Trait genes that harbor sentinel SNPs located in the 1kb range upstream and downstream of gene. Default: 1e6 bp}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{genomeVersion}{"grch38" or "grch37". Default: "grch38"}

\item{grch37To38}{TRUE or FALSE, we recommend converting grch37 to grch38, or using a input file of grch38 directly. Package \code{rtracklayer} is required.}

\item{overlapWithEGene}{TRUE(default) of FALSE. take the intersection with eGenes, egene data.frame will be automatically download from GTEx, or can be provided by the parameter \code{egeneDF} specified the data.frame of one column of genecode ID.  Default:TRUE}

\item{egeneDF}{A data.table object of one column of gencode ID. requiring overlapWithEGene is TRUE.}
}
\value{
A data.table object
}
\description{
Identify trait genes using sentinel SNPs generated from \code{xQTLanalyze_getSentinelSnp}
}
\examples{
\donttest{
# without a customized egene file,
URL1<-"https://gitee.com/stronghoney/exampleData/raw/master/gwas/GLGC_CG0052/sentinelSnpDF.txt"
sentinelSnpDF <- data.table::fread(URL1)
traitsAll <- xQTLanalyze_getTraits(sentinelSnpDF, detectRange=1e4,"Brain - Cerebellum",
                                   genomeVersion="grch37", grch37To38=TRUE)
# with a egene file:
egeneFile <- "https://raw.githubusercontent.com/dingruofan/exampleData/master/egeneDF.txt"
egeneDF <- data.table::fread(egeneFile)
traitsAll <- xQTLanalyze_getTraits(sentinelSnpDF, detectRange=1e4,"Brain - Cerebellum",
                                   genomeVersion="grch37", grch37To38=TRUE, egeneDF=egeneDF)
}
}
