% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{xQTLdownload_eqtl}
\alias{xQTLdownload_eqtl}
\title{Download significant or unsignificant eQTL associations of a tissue or across all tissues}
\usage{
xQTLdownload_eqtl(
  variantName = "",
  gene = "",
  variantType = "auto",
  geneType = "auto",
  tissueSiteDetail = "",
  datasetId = "gtex_v8",
  recordPerChunk = 100
)
}
\arguments{
\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported). Can not be null.}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{datasetId}{(character) options: "gtex_v8" (default), "gtex_v7".}

\item{recordPerChunk}{(integer) number of records fetched per request (default: 100).}
}
\value{
A data.table object.
}
\description{
can be quried with a gene/variant-gene pair.
}
\examples{
\donttest{
# Download eQTL info with a gene symbol:
eqtlInfo <- xQTLdownload_eqtl(gene="TP53")

# Use unversioned gencode ID in GTEx V8:
eqtl_v8 <- xQTLdownload_eqtl(gene="ENSG00000141510", datasetId="gtex_v8")

# In a specific tissue:
xQTLdownload_eqtl(gene="ENSG00000141510.16", geneType="gencodeId", tissueSiteDetail="Thyroid" )

# Download eQTL info with a variant-gene pair:
xQTLdownload_eqtl(variantName="rs1641513",gene="TP53", datasetId="gtex_v8")
xQTLdownload_eqtl(variantName="chr1_1667948_A_G_b38", gene="SLC35E2B",
                  tissueSiteDetail="Kidney - Cortex")
}
}
