% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_select.R
\name{x3p_fuzzyselect}
\alias{x3p_fuzzyselect}
\title{Interactive selection of region of interest}
\usage{
x3p_fuzzyselect(x3p, col = "#FF0000", mad = 5, type = "plane", update = TRUE)
}
\arguments{
\item{x3p}{x3p file}

\item{col}{character value of the selection color}

\item{mad}{scalar}

\item{type}{only "plane" is implemented at the moment}

\item{update}{boolean value, whether the rgl window should be updated to show the selected rectangle}
}
\value{
x3p file with updated mask
}
\description{
Interactive selection of region of interest
}
\examples{
\dontrun{
if (interactive) {
  if (!file.exists("fadul1-1.x3p")) {
    url <- "https://tsapps.nist.gov/NRBTD/Studies/CartridgeMeasurement/DownloadMeasurement"
    file <- "2d9cc51f-6f66-40a0-973a-a9292dbee36d"
    download.file(file.path(url, file), destfile="fadul1-1.x3p")
  }
  x3p <- x3p_read("fadul1-1.x3p")
  x3p_image(x3p, size=c(500,500), zoom=.8)
  x3p <- x3p_fuzzyselect(x3p, update=TRUE, col="#FF0000") 

  logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
  x3p_image(logo, size=c(500,500), zoom = 1)
  x3p_fuzzyselect(logo, update=TRUE, col="#00FF00") 
}}
}
