\name{testFunction}
\alias{testFunction}
\title{Test function}
\description{Apply data to function signature and record results.}
\usage{
testFunction(function_f_1,
             generatedData_l,
             functionName_s_1 = deparse(substitute(function_f_1)))
}
\arguments{
  \item{function_f_1}{ a single \R \emph{\code{function}}, offensive programming ready, with
  using semantic argument names }
  \item{generatedData_l}{
data to apply to the function. Could be generated by \emph{\bold{\code{\link{generateData}}}}
function is desired.
}
  \item{functionName_s_1}{A \emph{\code{string}} that is the function name.
  Particularly useful, in scripts.
}
}
\details{
Executes code and captures execution context and result, for posterior analysis.
}
\value{
A \emph{\code{list}} with following names
\tabular{ll}{
\bold{\code{generation}} \tab argument name generation \cr
\bold{\code{data}} \tab generated data \cr
\bold{\code{context}} \tab data tyep generation context \cr
\bold{\code{n}} \tab number of first level data generated \cr
}
Generated data are ready for use and accessible using the \bold{\code{data}} name of
the \emph{\code{list}}.
}
\seealso{
Refer to \code{\link{opwf}}.
}
\examples{
# typical example
op_sum <- opwf(sum, c('...', 'removeNA_b_1'))
op_sum_atr <- list('...' = c('i', 'd', 'c'))
ec <- setGenerationContext(0, TRUE, FALSE)
gd <- generateData(op_sum, op_sum_atr, ec, erc$hetero_vector[[1]], dac$none)
tf <- testFunction(op_sum, gd$data)
}
\keyword{ programming }
\keyword{ utilities }
\concept{ meta testing }
