% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtss.R
\docType{methods}
\name{timeSeries}
\alias{timeSeries}
\alias{timeSeries,WTSS-method}
\title{Get time series}
\usage{
timeSeries(object, coverages, attributes, longitude, latitude, start_date,
  end_date)

\S4method{timeSeries}{WTSS}(object, coverages, attributes, longitude, latitude,
  start_date, end_date)
}
\arguments{
\item{object}{Either a WTSS object or a server URL}

\item{coverages}{Either a list of coverages and attributes such as retrieved by describe_coverage() or a character with the coverage name.}

\item{attributes}{A character vector of dataset names.}

\item{longitude}{A longitude in WGS84 coordinate system.}

\item{latitude}{A latitude in WGS84 coordinate system.}

\item{start_date}{A character with the start date in the format yyyy-mm-dd or yyyy-mm depending on the coverage.}

\item{end_date}{A character with the end date in the format yyyy-mm-dd or yyyy-mm depending on the coverage.}
}
\description{
This function retrieves the time series for a pair of coordinates.es
}
\examples{
\donttest{
ts.server = WTSS("http://www.dpi.inpe.br/tws/wtss")
ts = timeSeries(ts.server, "mod13q1_512", c("ndvi","evi"), 
                longitude = -45.00, latitude  = -12.00,
                start_date = "2000-02-18", end_date = "2016-12-18")
}
}
