% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wlmfit.R
\name{wlmfit}
\alias{wlmfit}
\title{Fits a wavelet linear model}
\usage{
wlmfit(wts, norm)
}
\arguments{
\item{wts}{List of normalized transforms, normalized as specified in \code{norm}. Each entry a locations x time x timescales array of transforms. The first is the response variable, others are the predictors.}

\item{norm}{The normalization that was used. One of "none", "powall", "powind". See details.}
}
\value{
\code{wlmfit} returns a list with these elements:
\item{coefs}{Model coefficients}
\item{modval}{The right had side of the model}
\item{coher}{Appropriately normalized coherence of the model and response variable}
}
\description{
Stripped down internal function for doing the fitting
}
\details{
Only \code{norm="powall"} works now, other options throw an error.
}
\note{
Internal function, no error checking done.
}
\references{
Sheppard, LW et al. (2019) Synchrony is more than its top-down and climatic parts: interacting 
Moran effects on phytoplankton in British seas. Plos Computational Biology 15, e1006744. doi: 10.1371/journal.pcbi.1006744
}
\author{
Thomas Anderson, \email{anderstl@gmail.com}, Jon Walter, \email{jaw3es@virginia.edu}; Lawrence 
Sheppard, \email{lwsheppard@ku.edu}; Daniel Reuman, \email{reuman@ku.edu}
}
