% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tts.R
\name{tts}
\alias{tts}
\title{Creator function for the \code{tts} class}
\usage{
tts(times, timescales, values)
}
\arguments{
\item{times}{A numeric vector of increasing real values, spacing 1}

\item{timescales}{A numeric vector with positive entries}

\item{values}{A complex or numeric matrix of dimensions \code{length(times)} by 
\code{length(timescales)}}
}
\value{
\code{tts} returns an object of class \code{tts}. Slots are: 
\item{times}{a numeric vector of evenly spaced times} 
\item{timescales}{a numeric vector of positive timescales}
\item{values}{a complex or numeric matrix of dimensions \code{length(times)} by \code{length(timescales)}}
}
\description{
The \code{tts} (time/timescale) class is for matrices for which the rows correspond 
to times and the columns correspond to timescales. This is a general class from 
which other classes inherit (e.g., \code{wt}, \code{wmf}, \code{wpmf}). \code{tts} 
inherits from the \code{list} class.
}
\examples{
times<-1:10
timescales<-1/c(1:10)
values<-matrix(1,length(times),length(timescales))
h<-tts(times,timescales,values)

}
\seealso{
\code{\link{tts_methods}}, \code{\link{wt}}, \code{\link{wmf}}, \code{\link{wpmf}},
\code{browseVignettes("wsyn")}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
