test_that("census_geo_api_names() for 2020", {
  # TODO: Verify against table names here: https://api.census.gov/data/2020/dec/dhc/variables.html
  
  expect_equal(
    census_geo_api_names("2020"),
    list(
      r_whi = "P12I_001N",
      r_bla = "P12B_001N",
      r_his = "P12H_001N",
      r_asi = c("P12D_001N", "P12E_001N"),
      r_oth = c("P12C_001N", "P12F_001N", "P12G_001N")
    )
  )
  
  expect_equal(
    census_geo_api_names("2020", age = FALSE, sex = TRUE),
    c(
      census_geo_api_names("2020", age = FALSE, sex = FALSE),
      list(
        r_mal_whi = "P12I_002N",
        r_mal_bla = "P12B_002N",
        r_mal_his = "P12H_002N",
        r_mal_asi = c("P12D_002N", "P12E_002N"),
        r_mal_oth = c("P12C_002N", "P12F_002N", "P12G_002N"),
        r_fem_whi = "P12I_026N",
        r_fem_bla = "P12B_026N",
        r_fem_his = "P12H_026N",
        r_fem_asi = c("P12D_026N", "P12E_026N"),
        r_fem_oth = c("P12C_026N", "P12F_026N", "P12G_026N")
      )
    )
  )
  
  expect_equal(
    census_geo_api_names("2020", age = TRUE, sex = FALSE),
    c(
      census_geo_api_names("2020", age = FALSE, sex = FALSE),
      list(
        r_1_whi = c("P12I_003N", "P12I_027N"),
        r_1_bla = c("P12B_003N", "P12B_027N"),
        r_1_his = c("P12H_003N", "P12H_027N"),
        r_1_asi = c("P12D_003N", "P12E_003N", "P12D_027N", "P12E_027N"),
        r_1_oth = c("P12C_003N", "P12F_003N", "P12G_003N", "P12C_027N", "P12F_027N", "P12G_027N"),
        r_2_whi = c("P12I_004N", "P12I_028N"),
        r_2_bla = c("P12B_004N", "P12B_028N"),
        r_2_his = c("P12H_004N", "P12H_028N"),
        r_2_asi = c("P12D_004N", "P12E_004N", "P12D_028N", "P12E_028N"),
        r_2_oth = c("P12C_004N", "P12F_004N", "P12G_004N", "P12C_028N", "P12F_028N", "P12G_028N"),
        r_3_whi = c("P12I_005N", "P12I_029N"),
        r_3_bla = c("P12B_005N", "P12B_029N"),
        r_3_his = c("P12H_005N", "P12H_029N"),
        r_3_asi = c("P12D_005N", "P12E_005N", "P12D_029N", "P12E_029N"),
        r_3_oth = c("P12C_005N", "P12F_005N", "P12G_005N", "P12C_029N", "P12F_029N", "P12G_029N"),
        r_4_whi = c("P12I_006N", "P12I_030N"),
        r_4_bla = c("P12B_006N", "P12B_030N"),
        r_4_his = c("P12H_006N", "P12H_030N"),
        r_4_asi = c("P12D_006N", "P12E_006N", "P12D_030N", "P12E_030N"),
        r_4_oth = c("P12C_006N", "P12F_006N", "P12G_006N", "P12C_030N", "P12F_030N", "P12G_030N"),
        r_5_whi = c("P12I_007N", "P12I_031N"),
        r_5_bla = c("P12B_007N", "P12B_031N"),
        r_5_his = c("P12H_007N", "P12H_031N"),
        r_5_asi = c("P12D_007N", "P12E_007N", "P12D_031N", "P12E_031N"),
        r_5_oth = c("P12C_007N", "P12F_007N", "P12G_007N", "P12C_031N", "P12F_031N", "P12G_031N"),
        r_6_whi = c("P12I_008N", "P12I_032N"),
        r_6_bla = c("P12B_008N", "P12B_032N"),
        r_6_his = c("P12H_008N", "P12H_032N"),
        r_6_asi = c("P12D_008N", "P12E_008N", "P12D_032N", "P12E_032N"),
        r_6_oth = c("P12C_008N", "P12F_008N", "P12G_008N", "P12C_032N", "P12F_032N", "P12G_032N"),
        r_7_whi = c("P12I_009N", "P12I_033N"),
        r_7_bla = c("P12B_009N", "P12B_033N"),
        r_7_his = c("P12H_009N", "P12H_033N"),
        r_7_asi = c("P12D_009N", "P12E_009N", "P12D_033N", "P12E_033N"),
        r_7_oth = c("P12C_009N", "P12F_009N", "P12G_009N", "P12C_033N", "P12F_033N", "P12G_033N"),
        r_8_whi = c("P12I_010N", "P12I_034N"),
        r_8_bla = c("P12B_010N", "P12B_034N"),
        r_8_his = c("P12H_010N", "P12H_034N"),
        r_8_asi = c("P12D_010N", "P12E_010N", "P12D_034N", "P12E_034N"),
        r_8_oth = c("P12C_010N", "P12F_010N", "P12G_010N", "P12C_034N", "P12F_034N", "P12G_034N"),
        r_9_whi = c("P12I_011N", "P12I_035N"),
        r_9_bla = c("P12B_011N", "P12B_035N"),
        r_9_his = c("P12H_011N", "P12H_035N"),
        r_9_asi = c("P12D_011N", "P12E_011N", "P12D_035N", "P12E_035N"),
        r_9_oth = c("P12C_011N", "P12F_011N", "P12G_011N", "P12C_035N", "P12F_035N", "P12G_035N"),
        r_10_whi = c("P12I_012N", "P12I_036N"),
        r_10_bla = c("P12B_012N", "P12B_036N"),
        r_10_his = c("P12H_012N", "P12H_036N"),
        r_10_asi = c("P12D_012N", "P12E_012N", "P12D_036N", "P12E_036N"),
        r_10_oth = c("P12C_012N", "P12F_012N", "P12G_012N", "P12C_036N", "P12F_036N", "P12G_036N"),
        r_11_whi = c("P12I_013N", "P12I_037N"),
        r_11_bla = c("P12B_013N", "P12B_037N"),
        r_11_his = c("P12H_013N", "P12H_037N"),
        r_11_asi = c("P12D_013N", "P12E_013N", "P12D_037N", "P12E_037N"),
        r_11_oth = c("P12C_013N", "P12F_013N", "P12G_013N", "P12C_037N", "P12F_037N", "P12G_037N"),
        r_12_whi = c("P12I_014N", "P12I_038N"),
        r_12_bla = c("P12B_014N", "P12B_038N"),
        r_12_his = c("P12H_014N", "P12H_038N"),
        r_12_asi = c("P12D_014N", "P12E_014N", "P12D_038N", "P12E_038N"),
        r_12_oth = c("P12C_014N", "P12F_014N", "P12G_014N", "P12C_038N", "P12F_038N", "P12G_038N"),
        r_13_whi = c("P12I_015N", "P12I_039N"),
        r_13_bla = c("P12B_015N", "P12B_039N"),
        r_13_his = c("P12H_015N", "P12H_039N"),
        r_13_asi = c("P12D_015N", "P12E_015N", "P12D_039N", "P12E_039N"),
        r_13_oth = c("P12C_015N", "P12F_015N", "P12G_015N", "P12C_039N", "P12F_039N", "P12G_039N"),
        r_14_whi = c("P12I_016N", "P12I_040N"),
        r_14_bla = c("P12B_016N", "P12B_040N"),
        r_14_his = c("P12H_016N", "P12H_040N"),
        r_14_asi = c("P12D_016N", "P12E_016N", "P12D_040N", "P12E_040N"),
        r_14_oth = c("P12C_016N", "P12F_016N", "P12G_016N", "P12C_040N", "P12F_040N", "P12G_040N"),
        r_15_whi = c("P12I_017N", "P12I_041N"),
        r_15_bla = c("P12B_017N", "P12B_041N"),
        r_15_his = c("P12H_017N", "P12H_041N"),
        r_15_asi = c("P12D_017N", "P12E_017N", "P12D_041N", "P12E_041N"),
        r_15_oth = c("P12C_017N", "P12F_017N", "P12G_017N", "P12C_041N", "P12F_041N", "P12G_041N"),
        r_16_whi = c("P12I_018N", "P12I_042N"),
        r_16_bla = c("P12B_018N", "P12B_042N"),
        r_16_his = c("P12H_018N", "P12H_042N"),
        r_16_asi = c("P12D_018N", "P12E_018N", "P12D_042N", "P12E_042N"),
        r_16_oth = c("P12C_018N", "P12F_018N", "P12G_018N", "P12C_042N", "P12F_042N", "P12G_042N"),
        r_17_whi = c("P12I_019N", "P12I_043N"),
        r_17_bla = c("P12B_019N", "P12B_043N"),
        r_17_his = c("P12H_019N", "P12H_043N"),
        r_17_asi = c("P12D_019N", "P12E_019N", "P12D_043N", "P12E_043N"),
        r_17_oth = c("P12C_019N", "P12F_019N", "P12G_019N", "P12C_043N", "P12F_043N", "P12G_043N"),
        r_18_whi = c("P12I_020N", "P12I_044N"),
        r_18_bla = c("P12B_020N", "P12B_044N"),
        r_18_his = c("P12H_020N", "P12H_044N"),
        r_18_asi = c("P12D_020N", "P12E_020N", "P12D_044N", "P12E_044N"),
        r_18_oth = c("P12C_020N", "P12F_020N", "P12G_020N", "P12C_044N", "P12F_044N", "P12G_044N"),
        r_19_whi = c("P12I_021N", "P12I_045N"),
        r_19_bla = c("P12B_021N", "P12B_045N"),
        r_19_his = c("P12H_021N", "P12H_045N"),
        r_19_asi = c("P12D_021N", "P12E_021N", "P12D_045N", "P12E_045N"),
        r_19_oth = c("P12C_021N", "P12F_021N", "P12G_021N", "P12C_045N", "P12F_045N", "P12G_045N"),
        r_20_whi = c("P12I_022N", "P12I_046N"),
        r_20_bla = c("P12B_022N", "P12B_046N"),
        r_20_his = c("P12H_022N", "P12H_046N"),
        r_20_asi = c("P12D_022N", "P12E_022N", "P12D_046N", "P12E_046N"),
        r_20_oth = c("P12C_022N", "P12F_022N", "P12G_022N", "P12C_046N", "P12F_046N", "P12G_046N"),
        r_21_whi = c("P12I_023N", "P12I_047N"),
        r_21_bla = c("P12B_023N", "P12B_047N"),
        r_21_his = c("P12H_023N", "P12H_047N"),
        r_21_asi = c("P12D_023N", "P12E_023N", "P12D_047N", "P12E_047N"),
        r_21_oth = c("P12C_023N", "P12F_023N", "P12G_023N", "P12C_047N", "P12F_047N", "P12G_047N"),
        r_22_whi = c("P12I_024N", "P12I_048N"),
        r_22_bla = c("P12B_024N", "P12B_048N"),
        r_22_his = c("P12H_024N", "P12H_048N"),
        r_22_asi = c("P12D_024N", "P12E_024N", "P12D_048N", "P12E_048N"),
        r_22_oth = c("P12C_024N", "P12F_024N", "P12G_024N", "P12C_048N", "P12F_048N", "P12G_048N"),
        r_23_whi = c("P12I_025N", "P12I_049N"),
        r_23_bla = c("P12B_025N", "P12B_049N"),
        r_23_his = c("P12H_025N", "P12H_049N"),
        r_23_asi = c("P12D_025N", "P12E_025N", "P12D_049N", "P12E_049N"),
        r_23_oth = c("P12C_025N", "P12F_025N", "P12G_025N", "P12C_049N", "P12F_049N", "P12G_049N")
      )
    )
  )
  
  expect_equal(
    census_geo_api_names("2020", age = TRUE, sex = TRUE),
    c(
      census_geo_api_names("2020", age = FALSE, sex = FALSE),
      list(
        r_mal_1_whi = "P12I_003N",
        r_mal_1_bla = "P12B_003N",
        r_mal_1_his = "P12H_003N",
        r_mal_1_asi = c("P12D_003N", "P12E_003N"),
        r_mal_1_oth = c("P12C_003N", "P12F_003N", "P12G_003N"),
        r_mal_2_whi = "P12I_004N",
        r_mal_2_bla = "P12B_004N",
        r_mal_2_his = "P12H_004N",
        r_mal_2_asi = c("P12D_004N", "P12E_004N"),
        r_mal_2_oth = c("P12C_004N", "P12F_004N", "P12G_004N"),
        r_mal_3_whi = "P12I_005N",
        r_mal_3_bla = "P12B_005N",
        r_mal_3_his = "P12H_005N",
        r_mal_3_asi = c("P12D_005N", "P12E_005N"),
        r_mal_3_oth = c("P12C_005N", "P12F_005N", "P12G_005N"),
        r_mal_4_whi = "P12I_006N",
        r_mal_4_bla = "P12B_006N",
        r_mal_4_his = "P12H_006N",
        r_mal_4_asi = c("P12D_006N", "P12E_006N"),
        r_mal_4_oth = c("P12C_006N", "P12F_006N", "P12G_006N"),
        r_mal_5_whi = "P12I_007N",
        r_mal_5_bla = "P12B_007N",
        r_mal_5_his = "P12H_007N",
        r_mal_5_asi = c("P12D_007N", "P12E_007N"),
        r_mal_5_oth = c("P12C_007N", "P12F_007N", "P12G_007N"),
        r_mal_6_whi = "P12I_008N",
        r_mal_6_bla = "P12B_008N",
        r_mal_6_his = "P12H_008N",
        r_mal_6_asi = c("P12D_008N", "P12E_008N"),
        r_mal_6_oth = c("P12C_008N", "P12F_008N", "P12G_008N"),
        r_mal_7_whi = "P12I_009N",
        r_mal_7_bla = "P12B_009N",
        r_mal_7_his = "P12H_009N",
        r_mal_7_asi = c("P12D_009N", "P12E_009N"),
        r_mal_7_oth = c("P12C_009N", "P12F_009N", "P12G_009N"),
        r_mal_8_whi = "P12I_010N",
        r_mal_8_bla = "P12B_010N",
        r_mal_8_his = "P12H_010N",
        r_mal_8_asi = c("P12D_010N", "P12E_010N"),
        r_mal_8_oth = c("P12C_010N", "P12F_010N", "P12G_010N"),
        r_mal_9_whi = "P12I_011N",
        r_mal_9_bla = "P12B_011N",
        r_mal_9_his = "P12H_011N",
        r_mal_9_asi = c("P12D_011N", "P12E_011N"),
        r_mal_9_oth = c("P12C_011N", "P12F_011N", "P12G_011N"),
        r_mal_10_whi = "P12I_012N",
        r_mal_10_bla = "P12B_012N",
        r_mal_10_his = "P12H_012N",
        r_mal_10_asi = c("P12D_012N", "P12E_012N"),
        r_mal_10_oth = c("P12C_012N", "P12F_012N", "P12G_012N"),
        r_mal_11_whi = "P12I_013N",
        r_mal_11_bla = "P12B_013N",
        r_mal_11_his = "P12H_013N",
        r_mal_11_asi = c("P12D_013N", "P12E_013N"),
        r_mal_11_oth = c("P12C_013N", "P12F_013N", "P12G_013N"),
        r_mal_12_whi = "P12I_014N",
        r_mal_12_bla = "P12B_014N",
        r_mal_12_his = "P12H_014N",
        r_mal_12_asi = c("P12D_014N", "P12E_014N"),
        r_mal_12_oth = c("P12C_014N", "P12F_014N", "P12G_014N"),
        r_mal_13_whi = "P12I_015N",
        r_mal_13_bla = "P12B_015N",
        r_mal_13_his = "P12H_015N",
        r_mal_13_asi = c("P12D_015N", "P12E_015N"),
        r_mal_13_oth = c("P12C_015N", "P12F_015N", "P12G_015N"),
        r_mal_14_whi = "P12I_016N",
        r_mal_14_bla = "P12B_016N",
        r_mal_14_his = "P12H_016N",
        r_mal_14_asi = c("P12D_016N", "P12E_016N"),
        r_mal_14_oth = c("P12C_016N", "P12F_016N", "P12G_016N"),
        r_mal_15_whi = "P12I_017N",
        r_mal_15_bla = "P12B_017N",
        r_mal_15_his = "P12H_017N",
        r_mal_15_asi = c("P12D_017N", "P12E_017N"),
        r_mal_15_oth = c("P12C_017N", "P12F_017N", "P12G_017N"),
        r_mal_16_whi = "P12I_018N",
        r_mal_16_bla = "P12B_018N",
        r_mal_16_his = "P12H_018N",
        r_mal_16_asi = c("P12D_018N", "P12E_018N"),
        r_mal_16_oth = c("P12C_018N", "P12F_018N", "P12G_018N"),
        r_mal_17_whi = "P12I_019N",
        r_mal_17_bla = "P12B_019N",
        r_mal_17_his = "P12H_019N",
        r_mal_17_asi = c("P12D_019N", "P12E_019N"),
        r_mal_17_oth = c("P12C_019N", "P12F_019N", "P12G_019N"),
        r_mal_18_whi = "P12I_020N",
        r_mal_18_bla = "P12B_020N",
        r_mal_18_his = "P12H_020N",
        r_mal_18_asi = c("P12D_020N", "P12E_020N"),
        r_mal_18_oth = c("P12C_020N", "P12F_020N", "P12G_020N"),
        r_mal_19_whi = "P12I_021N",
        r_mal_19_bla = "P12B_021N",
        r_mal_19_his = "P12H_021N",
        r_mal_19_asi = c("P12D_021N", "P12E_021N"),
        r_mal_19_oth = c("P12C_021N", "P12F_021N", "P12G_021N"),
        r_mal_20_whi = "P12I_022N",
        r_mal_20_bla = "P12B_022N",
        r_mal_20_his = "P12H_022N",
        r_mal_20_asi = c("P12D_022N", "P12E_022N"),
        r_mal_20_oth = c("P12C_022N", "P12F_022N", "P12G_022N"),
        r_mal_21_whi = "P12I_023N",
        r_mal_21_bla = "P12B_023N",
        r_mal_21_his = "P12H_023N",
        r_mal_21_asi = c("P12D_023N", "P12E_023N"),
        r_mal_21_oth = c("P12C_023N", "P12F_023N", "P12G_023N"),
        r_mal_22_whi = "P12I_024N",
        r_mal_22_bla = "P12B_024N",
        r_mal_22_his = "P12H_024N",
        r_mal_22_asi = c("P12D_024N", "P12E_024N"),
        r_mal_22_oth = c("P12C_024N", "P12F_024N", "P12G_024N"),
        r_mal_23_whi = "P12I_025N",
        r_mal_23_bla = "P12B_025N",
        r_mal_23_his = "P12H_025N",
        r_mal_23_asi = c("P12D_025N", "P12E_025N"),
        r_mal_23_oth = c("P12C_025N", "P12F_025N", "P12G_025N"),
        r_fem_1_whi = "P12I_027N",
        r_fem_1_bla = "P12B_027N",
        r_fem_1_his = "P12H_027N",
        r_fem_1_asi = c("P12D_027N", "P12E_027N"),
        r_fem_1_oth = c("P12C_027N", "P12F_027N", "P12G_027N"),
        r_fem_2_whi = "P12I_028N",
        r_fem_2_bla = "P12B_028N",
        r_fem_2_his = "P12H_028N",
        r_fem_2_asi = c("P12D_028N", "P12E_028N"),
        r_fem_2_oth = c("P12C_028N", "P12F_028N", "P12G_028N"),
        r_fem_3_whi = "P12I_029N",
        r_fem_3_bla = "P12B_029N",
        r_fem_3_his = "P12H_029N",
        r_fem_3_asi = c("P12D_029N", "P12E_029N"),
        r_fem_3_oth = c("P12C_029N", "P12F_029N", "P12G_029N"),
        r_fem_4_whi = "P12I_030N",
        r_fem_4_bla = "P12B_030N",
        r_fem_4_his = "P12H_030N",
        r_fem_4_asi = c("P12D_030N", "P12E_030N"),
        r_fem_4_oth = c("P12C_030N", "P12F_030N", "P12G_030N"),
        r_fem_5_whi = "P12I_031N",
        r_fem_5_bla = "P12B_031N",
        r_fem_5_his = "P12H_031N",
        r_fem_5_asi = c("P12D_031N", "P12E_031N"),
        r_fem_5_oth = c("P12C_031N", "P12F_031N", "P12G_031N"),
        r_fem_6_whi = "P12I_032N",
        r_fem_6_bla = "P12B_032N",
        r_fem_6_his = "P12H_032N",
        r_fem_6_asi = c("P12D_032N", "P12E_032N"),
        r_fem_6_oth = c("P12C_032N", "P12F_032N", "P12G_032N"),
        r_fem_7_whi = "P12I_033N",
        r_fem_7_bla = "P12B_033N",
        r_fem_7_his = "P12H_033N",
        r_fem_7_asi = c("P12D_033N", "P12E_033N"),
        r_fem_7_oth = c("P12C_033N", "P12F_033N", "P12G_033N"),
        r_fem_8_whi = "P12I_034N",
        r_fem_8_bla = "P12B_034N",
        r_fem_8_his = "P12H_034N",
        r_fem_8_asi = c("P12D_034N", "P12E_034N"),
        r_fem_8_oth = c("P12C_034N", "P12F_034N", "P12G_034N"),
        r_fem_9_whi = "P12I_035N",
        r_fem_9_bla = "P12B_035N",
        r_fem_9_his = "P12H_035N",
        r_fem_9_asi = c("P12D_035N", "P12E_035N"),
        r_fem_9_oth = c("P12C_035N", "P12F_035N", "P12G_035N"),
        r_fem_10_whi = "P12I_036N",
        r_fem_10_bla = "P12B_036N",
        r_fem_10_his = "P12H_036N",
        r_fem_10_asi = c("P12D_036N", "P12E_036N"),
        r_fem_10_oth = c("P12C_036N", "P12F_036N", "P12G_036N"),
        r_fem_11_whi = "P12I_037N",
        r_fem_11_bla = "P12B_037N",
        r_fem_11_his = "P12H_037N",
        r_fem_11_asi = c("P12D_037N", "P12E_037N"),
        r_fem_11_oth = c("P12C_037N", "P12F_037N", "P12G_037N"),
        r_fem_12_whi = "P12I_038N",
        r_fem_12_bla = "P12B_038N",
        r_fem_12_his = "P12H_038N",
        r_fem_12_asi = c("P12D_038N", "P12E_038N"),
        r_fem_12_oth = c("P12C_038N", "P12F_038N", "P12G_038N"),
        r_fem_13_whi = "P12I_039N",
        r_fem_13_bla = "P12B_039N",
        r_fem_13_his = "P12H_039N",
        r_fem_13_asi = c("P12D_039N", "P12E_039N"),
        r_fem_13_oth = c("P12C_039N", "P12F_039N", "P12G_039N"),
        r_fem_14_whi = "P12I_040N",
        r_fem_14_bla = "P12B_040N",
        r_fem_14_his = "P12H_040N",
        r_fem_14_asi = c("P12D_040N", "P12E_040N"),
        r_fem_14_oth = c("P12C_040N", "P12F_040N", "P12G_040N"),
        r_fem_15_whi = "P12I_041N",
        r_fem_15_bla = "P12B_041N",
        r_fem_15_his = "P12H_041N",
        r_fem_15_asi = c("P12D_041N", "P12E_041N"),
        r_fem_15_oth = c("P12C_041N", "P12F_041N", "P12G_041N"),
        r_fem_16_whi = "P12I_042N",
        r_fem_16_bla = "P12B_042N",
        r_fem_16_his = "P12H_042N",
        r_fem_16_asi = c("P12D_042N", "P12E_042N"),
        r_fem_16_oth = c("P12C_042N", "P12F_042N", "P12G_042N"),
        r_fem_17_whi = "P12I_043N",
        r_fem_17_bla = "P12B_043N",
        r_fem_17_his = "P12H_043N",
        r_fem_17_asi = c("P12D_043N", "P12E_043N"),
        r_fem_17_oth = c("P12C_043N", "P12F_043N", "P12G_043N"),
        r_fem_18_whi = "P12I_044N",
        r_fem_18_bla = "P12B_044N",
        r_fem_18_his = "P12H_044N",
        r_fem_18_asi = c("P12D_044N", "P12E_044N"),
        r_fem_18_oth = c("P12C_044N", "P12F_044N", "P12G_044N"),
        r_fem_19_whi = "P12I_045N",
        r_fem_19_bla = "P12B_045N",
        r_fem_19_his = "P12H_045N",
        r_fem_19_asi = c("P12D_045N", "P12E_045N"),
        r_fem_19_oth = c("P12C_045N", "P12F_045N", "P12G_045N"),
        r_fem_20_whi = "P12I_046N",
        r_fem_20_bla = "P12B_046N",
        r_fem_20_his = "P12H_046N",
        r_fem_20_asi = c("P12D_046N", "P12E_046N"),
        r_fem_20_oth = c("P12C_046N", "P12F_046N", "P12G_046N"),
        r_fem_21_whi = "P12I_047N",
        r_fem_21_bla = "P12B_047N",
        r_fem_21_his = "P12H_047N",
        r_fem_21_asi = c("P12D_047N", "P12E_047N"),
        r_fem_21_oth = c("P12C_047N", "P12F_047N", "P12G_047N"),
        r_fem_22_whi = "P12I_048N",
        r_fem_22_bla = "P12B_048N",
        r_fem_22_his = "P12H_048N",
        r_fem_22_asi = c("P12D_048N", "P12E_048N"),
        r_fem_22_oth = c("P12C_048N", "P12F_048N", "P12G_048N"),
        r_fem_23_whi = "P12I_049N",
        r_fem_23_bla = "P12B_049N",
        r_fem_23_his = "P12H_049N",
        r_fem_23_asi = c("P12D_049N", "P12E_049N"),
        r_fem_23_oth = c("P12C_049N", "P12F_049N", "P12G_049N")
      )
    )
  )
})

test_that("census_geo_api_url()", {
  expect_equal(
    census_geo_api_url("2020"),
    "https://api.census.gov/data/2020/dec/dhc?"
  )
  expect_equal(
    census_geo_api_url("2010"),
    "https://api.census.gov/data/2010/dec/sf1?"
  )
  expect_equal(
    census_geo_api_url("2000"),
    "https://api.census.gov/data/2000/dec/sf1?"
  )
  expect_error(census_geo_api_url("2023"))
})
