% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_census_api_2.R
\name{get_census_api_2}
\alias{get_census_api_2}
\title{Census API URL assembler.}
\usage{
get_census_api_2(data_url, key, get, region, retry = 0)
}
\arguments{
\item{data_url}{URL root of the API, including the question mark, 
e.g., \code{"http://api.census.gov/data/2010/sf1?"}.}

\item{key}{A required character object containing user's Census API key, 
which can be requested \href{http://api.census.gov/data/key_signup.html}{here}.}

\item{get}{A character vector of variables to get, 
e.g., \code{c("P0050003","P0050004","P0050005", "P0050006")}.
If there are more than 50 variables, then function will automatically 
split variables into separate queries.}

\item{region}{Character object specifying which region to obtain data for.
Must contain "for" and possibly "in", 
e.g., \code{"for=block:1213&in=state:47+county:015+tract:*"}.}

\item{retry}{The number of retries at the census website if network interruption occurs.}
}
\value{
If successful, output will be an object of class \code{data.frame}. 
 If unsuccessful, function prints the URL query that was constructed.
}
\description{
\code{get_census_api_2} assembles URL components for \code{get_census_api}.
}
\details{
This function assembles the URL components and sends the request to the Census server. 
It is used by the \code{get_census_api} function. The user should not need to call this 
function directly.
}
\examples{
\dontrun{get_census_api_2(data_url = "http://api.census.gov/data/2010/sf1?", key = "...", 
get = c("P0050003","P0050004","P0050005", "P0050006"), region = "for=county:*&in=state:34")}

}
\references{
Based on code authored by Nicholas Nagle, which is available 
\href{http://rstudio-pubs-static.s3.amazonaws.com/19337_2e7f827190514c569ea136db788ce850.html}{here}.
}

