% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census.helper.api.R
\name{census.helper.api}
\alias{census.helper.api}
\title{Census helper function.}
\usage{
census.helper.api(key, voters, states = "all", geo = "tract",
  demo = FALSE, census.data = NA)
}
\arguments{
\item{key}{A required character object. Must contain user's Census API
key, which can be requested \href{http://api.census.gov/data/key_signup.html}{here}.}

\item{voters}{An object of class \code{data.frame}. Must contain field(s) 
named \code{\var{county}}, \code{\var{tract}}, and/or \code{\var{block}} 
specifying geolocation. These should be character variables that match up with 
U.S. Census categories. County should be three characters (e.g., "031" not "31"), 
tract should be six characters, and block should be four characters.}

\item{states}{A character vector specifying which states to extract 
Census data for, e.g. \code{c("NJ", "NY")}. Default is \code{"all"}, which extracts 
Census data for all states contained in user-input data.}

\item{geo}{A character object specifying what aggregation level to use. 
Use \code{"county"}, \code{"tract"}, or \code{"block"}. Default is \code{"tract"}. 
Warning: extracting block-level data takes very long.}

\item{demo}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on 
demographics (i.e., age and sex) or not. If \code{TRUE}, function will return 
Pr(Geolocation, Age, Sex | Race). If \code{FALSE}, function wil return 
Pr(Geolocation | Race). Default is \code{FALSE}.}

\item{census.data}{A optional census object holding census data that is already 
provided. If missing, function will retrive the census data online.}
}
\value{
Output will be an object of class \code{data.frame}. It will 
 consist of the original user-input data with additional columns of 
 Census data.
}
\description{
\code{census.helper.api} links user-input dataset with Census data.
}
\details{
This function allows users to link their geocoded dataset (e.g., voter file) 
with U.S. Census 2010 data. The function extracts Census Summary File data 
at the tract or block level using the 'UScensus2010' package. Census data 
calculated are Pr(Geolocation | Race) where geolocation is tract or block.
}
\examples{
\dontshow{data(voters)}
\dontrun{census.helper.api(key = "...", voters = voters, states = "nj", geo = "block")}
\dontrun{census.helper.api(key = "...", voters = voters, states = "all", geo = "tract", 
demo = TRUE)}

}
\references{
Relies on getCensusApi, getCensusApi2, and vecToChunk functions authored by Nicholas Nagle, 
available \href{http://rstudio-pubs-static.s3.amazonaws.com/19337_2e7f827190514c569ea136db788ce850.html}{here}.
}

