% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_utilities.R
\name{import_gamet}
\alias{import_gamet}
\title{Import a GAMET output file into R.}
\usage{
import_gamet(path)
}
\arguments{
\item{path}{A string giving the path and filename to import.}
}
\value{
A base \code{data.frame} with one row per record and the following columns:
\itemize{
  \item \code{ID} (\code{character}): unique identifier of the text/essay.
  \item One column per retained GAMET error/category variable (\code{numeric};
        typically counts or rates). Column names follow the GAMET output
        variable names.
}
The object has class \code{data.frame} (or \code{tibble} if converted by the user).
}
\description{
Import a GAMET output file into R.
}
\examples{
# Example with package sample data
file_path   <- system.file("extdata", "sample_gamet.csv", package = "writeAlizer")
gamet_file  <- import_gamet(file_path)
head(gamet_file)
}
\seealso{
\code{\link{predict_quality}}
}
