% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack.R
\name{[<-.Unpacker}
\alias{[<-.Unpacker}
\title{Unpack or bind values into the calling environment.}
\usage{
\method{[}{Unpacker}(wrapr_private_self, ...) <- value
}
\arguments{
\item{wrapr_private_self}{object implementing the feature, wrapr::unpack}

\item{...}{names of to unpack to (can be escaped with bquote \code{.()} notation).}

\item{value}{list to unpack into values, must have a number of entries equal to number of \code{...} arguments}
}
\value{
wrapr_private_self
}
\description{
Unpacks or binds values into the calling environment. Uses \code{bquote} escaping.
NULL is a special case that is unpacked to all targets. NA targets are skipped.
All non-NA target names must be unique.
}
\details{
Note: when using \code{[]<-} notation, a reference to the unpacker object is written into the unpacking environment as a side-effect
of the implied array assignment. \code{:=} assigment does not have this side-effect.
Array-assign form can not use the names: \code{.}, \code{wrapr_private_self}, \code{value}, or the name of the unpacker itself.
For more details please see here \url{http://www.win-vector.com/blog/2020/01/unpack-your-values-in-r/}.

Related work includes \code{Python} tuple unpacking, \code{zeallot}'s arrow, and \code{vadr::bind}.
}
\examples{

# named unpacking
# looks like assignment: DESTINATION = NAME_VALUE_USING
d <- data.frame(x = 1:2,
                g=c('test', 'train'),
                stringsAsFactors = FALSE)
to[train_set = train, test_set = test] := split(d, d$g)
# train_set and test_set now correctly split
print(train_set)
print(test_set)
rm(list = c('train_set', 'test_set'))

# named unpacking NEWNAME = OLDNAME implicit form
# values are matched by name, not index
to[train, test] := split(d, d$g)
print(train)
print(test)
rm(list = c('train', 'test'))

# bquote example
train_col_name <- 'train'
test_col_name <- 'test'
to[train = .(train_col_name), test = .(test_col_name)] := split(d, d$g)
print(train)
print(test)
rm(list = c('train', 'test'))

}
