% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinateAllAndSum.R
\name{combinateAllAndSum}
\alias{combinateAllAndSum}
\title{Full combinatorial and cumulative values}
\usage{
combinateAllAndSum(
  nMax,
  modVal,
  notSingle = NULL,
  silent = TRUE,
  callFrom = NULL
)
}
\arguments{
\item{nMax}{(integer or data.frame with 1 line) maximum number of modifications}

\item{modVal}{(numeric, has to have names !) the change of molecular mass introduced by given modifications (as specified by the name of the value)}

\item{notSingle}{(character) names of 'modVal' where 1st element of 'notSingle'  cannot happen/appear if 2nd element not present (eg de-phospho/phosphorylation)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
named (concatenated names of modVal) numeric vector
}
\description{
Use for all preparing all combinations of non-compulsatory, ie variable, mass modifications
Variable modifications may or may not be present. Thus, for a given amino-acid with a variable modification two versions of the molecular weight need to be considered.
Most (variable) modifications are linked to a type of amino acid, like serine-residues for phosphorlylation.
Thus in this case, each instance of the amino acid in question may or may not be modified. 
So, for example if there are 2 serines, 0, 1 or 2 phosphorylation modifications may be present. 
For this reason the is the argument \code{nMax} to stay within biologically relevant ranges (external knowledge) and reduce complexity significantly.    
Some modifications are exclusive to others, argument \code{notSingle} : An (artificially occuring) de-phosphorylation event during fragmentation can only happen if the amino acid was already phosphorylated in the first place.
}
\examples{
## to follow easily the results, hypothetical mass-modification values were chosen
mo1 <- c(a=10, b=1, c=0.1, d=0.01); nMa1 <- c(1,2,0,3)
combinateAllAndSum(nMa1, mo1)
## # like 'b' for phospho & 'd' for de-phospho (which can't happen without phospho event)
combinateAllAndSum(nMa1, mo1, notSingle=c("d","b"))    
}
\seealso{
\code{\link[wrMisc]{convToNum}}
}
