% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrSpeciesAnnot.R
\name{extrSpeciesAnnot}
\alias{extrSpeciesAnnot}
\title{Extract species annotation}
\usage{
extrSpeciesAnnot(
  annot,
  spec = c("_CONT", "_HUMAN", "_YEAST", "_ECOLI"),
  shortNa = c("cont", "H", "S", "E"),
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{annot}{(character) vector with initial annotation}

\item{spec}{(character) the tags to be identified}

\item{shortNa}{(character) the final abbreviation used, order and lengt must fit to argument \code{annot}}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) display additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a character vector with single (last of multiple) term if found in argument \code{annot}
}
\description{
\code{extrSpeciesAnnot} identifies species-related annotation (as suffix to identifyers) for data comnining multiple species and returns alternative (short) names.  
This function also suppresses extra heading or tailing space or punctuation characters.
In case multiple tags are found, the last tag is reported and a message of alert may be displayed.
}
\examples{
spec <- c("keratin_CONT","AB_HUMAN","CD_YEAST","EF_G_HUMAN","HI_HUMAN_ECOLI","_YEAST_012")
extrSpeciesAnnot(spec) 
}
\seealso{
\code{\link[base]{grep}}
}
