% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmSharedWords.R
\name{rmSharedWords}
\alias{rmSharedWords}
\title{Trim/Remove Redundant Words}
\usage{
rmSharedWords(
  x,
  sep = c("_", " ", "."),
  anySep = TRUE,
  newSep = NULL,
  minLe = 2,
  na.omit = FALSE,
  fixed = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(character) main input for making non-redundant}

\item{sep}{(character) separator(s) to be used}

\item{anySep}{(logical) if \code{TRUE}, will consider all separators at one time (), thus combinations with different separators won't be distinguished}

\item{newSep}{(character) new (uniform) separator between words, if \code{NULL} the first value/separator of if \code{sep} will be used}

\item{minLe}{(integer) minimum length for allowing being recognised as 'word'}

\item{na.omit}{(logical) if \code{TRUE NA}s will be removed from output}

\item{fixed}{(logical) will be transmitted to argument \code{fixed} of \code{strsplit()};  if \code{TRUE} regular expressions are allowed/used}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns character vector of same length (unless \code{na.omit=TRUE}), simply with modified text-content
}
\description{
This function allows removing shared words, ie triming to non-redundant words.
}
\details{
Heading separators will be removed in any case (even if not followed by a 'word').

Special characters will be automatically protected.
When looking for repeated words, the order of such words does NOT matter, multiple repeats will be removed, too.
 
#'
}
\examples{
x1 <- c("aa_A1 yy_zz.txt", NA, "B2 yy_aa_aa_zz.txt")
rmSharedWords(x1)
 
}
\seealso{
\code{\link{trimRedundText}}
}
