% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkGroupOrder.R
\name{checkGrpOrder}
\alias{checkGrpOrder}
\title{checkGrpOrder}
\usage{
checkGrpOrder(
  x,
  rankExp = NULL,
  revRank = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{matrix or data.frame}

\item{rankExp}{(numeric) expected order for values in columns, default 'rankExp' =1:ncol(x)}

\item{revRank}{(logical) if 'revRank'=TRUE, the initial ranks & reversed ranks will be tested}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) display additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
vector of logical values
}
\description{
\code{checkGrpOrder} tests each line of 'x' if expected order appears. 
Used for comparing groups of measures with expected profile (simply by mataching expected order)
}
\examples{
set.seed(2005); mat1 <- rbind(matrix(round(runif(40),1),nc=4), rep(1,4))
checkGrpOrder(mat1)
checkGrpOrder(mat1,c(1,4,3,2))
}
\seealso{
\code{\link[wrMisc]{checkGrpOrderSEM}}
}
