% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_prdseason.R
\name{show_prdseason}
\alias{show_prdseason}
\title{Plot predictions for GAMs over time, by season}
\usage{
show_prdseason(mod, ylab, base_size = 11, xlim = NULL, ylim = NULL)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{ylab}{chr string for y-axis label}

\item{base_size}{numeric indicating base font size, passed to \code{\link[ggplot2]{theme_bw}}}

\item{xlim}{optional numeric vector of length two for x-axis limits}

\item{ylim}{optional numeric vector of length two for y-axis limits}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot predictions for GAMs over time, by season
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)
  
mod <- anlz_gam(tomod, trans = 'log10')
show_prdseason(mod, ylab = 'Chlorophyll-a (ug/L)')
}
\concept{show}
