% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrvar_count_all.R
\name{hrvar_count_all}
\alias{hrvar_count_all}
\title{Create count of distinct fields and percentage of employees with
missing values for all HR variables}
\usage{
hrvar_count_all(
  data,
  n_var = 50,
  return = "message",
  threshold = 100,
  maxna = 20,
  na_values = c("NA", "N/A", "#N/A", " ")
)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{n_var}{number of HR variables to include in report as rows. Default is
set to 50 HR variables.}

\item{return}{String to specify what to return}

\item{threshold}{The max number of unique values allowed for any attribute.
Default is 100.}

\item{maxna}{The max percentage of NAs allowable for any column. Default is
20.}

\item{na_values}{Character vector of values to be treated as missing. Default is
c("NA", "N/A", "#N/A", " ").}
}
\value{
Returns an error message by default, where 'text' is passed in \code{return}.
\itemize{
\item \code{'table'}: data frame. A summary table listing the number of distinct
fields and percentage of missing values for the specified number of HR
attributes will be returned.
\item \code{'message'}: outputs a message indicating which values are
beyond the specified thresholds.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function enables you to create a summary table to validate
organizational data. This table will provide a summary of the data found in
the Viva Insights \emph{Data sources} page. This function will return a summary
table with the count of distinct fields per HR attribute and the percentage
of employees with missing values for that attribute. See \code{hrvar_count()}
function for more detail on the specific HR attribute of interest.
}
\note{
As of v1.6.3, the function can detect and report text values like "NA",
"N/A", "#N/A", and spaces that represent missing values, by treating them as
NA values. You can customize which values are treated as missing with the
\code{na_values} parameter.
This can be validated as per:

\if{html}{\out{<div class="sourceCode">}}\preformatted{dv_data \%>\%
  mutate(TempOrg = sample(c("NA", "#N/A", " "), size = nrow(.), replace = TRUE)) \%>\%
  hrvar_count_all(return = "table")
}\if{html}{\out{</div>}}
}
\examples{
# Return a summary table of all HR attributes
hrvar_count_all(sq_data, return = "table")

}
\seealso{
Other Data Validation: 
\code{\link{check_query}()},
\code{\link{extract_hr}()},
\code{\link{flag_ch_ratio}()},
\code{\link{flag_em_ratio}()},
\code{\link{flag_extreme}()},
\code{\link{flag_outlooktime}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{identify_churn}()},
\code{\link{identify_holidayweeks}()},
\code{\link{identify_inactiveweeks}()},
\code{\link{identify_nkw}()},
\code{\link{identify_outlier}()},
\code{\link{identify_privacythreshold}()},
\code{\link{identify_query}()},
\code{\link{identify_shifts}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_tenure}()},
\code{\link{remove_outliers}()},
\code{\link{standardise_pq}()},
\code{\link{subject_validate}()},
\code{\link{subject_validate_report}()},
\code{\link{track_HR_change}()},
\code{\link{validation_report}()}
}
\concept{Data Validation}
